/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.lib;

import com.google.gson.JsonArray;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.ListCodec;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2680;
import net.minecraft.class_3518;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.PatternValidation;
import org.orecruncher.dsurround.lib.block.BlockStateMatcher;
import org.orecruncher.dsurround.lib.block.MatchOnBlockTag;
import org.orecruncher.dsurround.lib.block.MatchOnMaterial;

public interface CodecExtensions<A>
extends Codec<A> {
    public static Codec<String> checkHTMLColor() {
        Function<String, DataResult> func = value -> {
            if (PatternValidation.HTML_COLOR_ENCODING.matcher((CharSequence)value).matches()) {
                return DataResult.success((Object)value);
            }
            return DataResult.error((String)String.format("%s is not a valid HTML color description", value));
        };
        return Codec.STRING.flatXmap(func, func);
    }

    public static Codec<IMatcher<class_2680>> checkBlockStateSpecification(boolean allowTags, boolean allowMaterials) {
        Function<IMatcher, DataResult> func = value -> {
            if (!allowTags && value instanceof MatchOnBlockTag) {
                return DataResult.error((String)String.format("Current context does not allow block matching based on tags (%s)", value));
            }
            if (!allowMaterials && value instanceof MatchOnMaterial) {
                return DataResult.error((String)String.format("Current context does not allow block matching based on materials (%s)", value));
            }
            return DataResult.success((Object)value);
        };
        return BlockStateMatcher.CODEC.flatXmap(func, func);
    }

    public static <A> Optional<A> deserialize(String content, Codec<A> codec) {
        Dynamic dynamic;
        StringReader reader = new StringReader(content);
        if (codec instanceof ListCodec) {
            JsonArray jsonArray = class_3518.method_37165((Reader)reader);
            dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonArray);
        } else if (codec instanceof MapCodec) {
            jsonObject = class_3518.method_15255((Reader)reader);
            dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
        } else {
            jsonObject = class_3518.method_15255((Reader)reader);
            dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject);
        }
        try {
            DataResult result = codec.parse(dynamic);
            return result.resultOrPartial(x$0 -> Client.LOGGER.warn((String)x$0, new Object[0]));
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to parse input", new Object[0]);
            return Optional.empty();
        }
    }
}

