/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;

@Environment(value=EnvType.CLIENT)
final class SoundLibraryHelpers {
    SoundLibraryHelpers() {
    }

    public static Collection<IndividualSoundConfigEntry> getSortedSoundConfigurations() {
        TreeMap<class_2960, IndividualSoundConfigEntry> map = new TreeMap<class_2960, IndividualSoundConfigEntry>();
        for (class_3414 event : SoundLibrary.getRegisteredSoundEvents()) {
            IndividualSoundConfigEntry entry = IndividualSoundConfigEntry.createDefault(event);
            map.put(entry.soundEventId, entry);
        }
        for (IndividualSoundConfigEntry entry : Client.SoundConfig.getIndividualSoundConfigs()) {
            map.put(entry.soundEventId, entry);
        }
        Comparator<IndividualSoundConfigEntry> iscComparator = Comparator.comparing(isc -> isc.soundEventId);
        return map.values().stream().sorted(iscComparator).collect(Collectors.toList());
    }

    public static ConfigSoundInstance playSound(IndividualSoundConfigEntry entry) {
        ConfigSoundInstance sound = new ConfigSoundInstance(entry.soundEventId, entry.volumeScale);
        MinecraftAudioPlayer.INSTANCE.play((class_1113)sound);
        return sound;
    }

    public static void stopSound(ConfigSoundInstance sound) {
        MinecraftAudioPlayer.INSTANCE.stop((class_1113)sound);
    }

    public static boolean isPlaying(ConfigSoundInstance sound) {
        return MinecraftAudioPlayer.INSTANCE.isPlaying((class_1113)sound);
    }
}

