/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.gui.sound.ConfigSoundInstance;
import org.orecruncher.dsurround.gui.sound.SoundLibraryHelpers;
import org.orecruncher.dsurround.gui.sound.VolumeSliderControl;
import org.orecruncher.dsurround.lib.FrameworkUtils;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.gui.ButtonControl;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.gui.GuiHelpers;
import org.orecruncher.dsurround.sound.SoundMetadata;

@Environment(value=EnvType.CLIENT)
public class IndividualSoundControlListEntry
extends class_350.class_351<IndividualSoundControlListEntry>
implements AutoCloseable {
    private static final int BUTTON_WIDTH = 60;
    private static final int TOOLTIP_WIDTH = 300;
    private static final class_2561 CULL_ON = new class_2588("dsurround.text.soundconfig.cull");
    private static final class_2561 CULL_OFF = new class_2588("dsurround.text.soundconfig.nocull");
    private static final class_2561 BLOCK_ON = new class_2588("dsurround.text.soundconfig.block");
    private static final class_2561 BLOCK_OFF = new class_2588("dsurround.text.soundconfig.noblock");
    private static final class_2561 PLAY = new class_2588("dsurround.text.soundconfig.play");
    private static final class_2561 STOP = new class_2588("dsurround.text.soundconfig.stop");
    private static final class_5481 VANILLA_CREDIT = new class_2588("dsurround.text.soundconfig.vanilla").method_30937();
    private static final class_124[] CODING = new class_124[]{class_124.field_1056, class_124.field_1075};
    private static final Collection<class_5481> VOLUME_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.volume.help", 300, CODING);
    private static final Collection<class_5481> PLAY_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.play.help", 300, CODING);
    private static final Collection<class_5481> CULL_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.cull.help", 300, CODING);
    private static final Collection<class_5481> BLOCK_HELP = GuiHelpers.getTrimmedTextCollection("dsurround.text.soundconfig.block.help", 300, CODING);
    private static final class_2583 modNameStyle = class_2583.field_24360.method_27706(class_124.field_1065);
    private static final class_2583 idStyle = class_2583.field_24360.method_27706(class_124.field_1080);
    private static final int CONTROL_SPACING = 3;
    private final IndividualSoundConfigEntry config;
    private final VolumeSliderControl volume;
    private final ButtonControl blockButton;
    private final ButtonControl cullButton;
    private final ButtonControl playButton;
    private final List<class_339> children = new ArrayList<class_339>();
    private final List<class_5481> cachedToolTip = new ArrayList<class_5481>();
    private ConfigSoundInstance soundPlay;

    public IndividualSoundControlListEntry(IndividualSoundConfigEntry data, boolean enablePlay) {
        this.config = data;
        this.volume = new VolumeSliderControl(this, 0, 0);
        this.children.add((class_339)this.volume);
        this.blockButton = new ButtonControl(0, 0, 60, 0, this.config.block ? BLOCK_ON : BLOCK_OFF, this::toggleBlock);
        this.children.add((class_339)this.blockButton);
        this.cullButton = new ButtonControl(0, 0, 60, 0, this.config.cull ? CULL_ON : CULL_OFF, this::toggleCull);
        this.children.add((class_339)this.cullButton);
        this.playButton = new ButtonControl(0, 0, 60, 0, PLAY, this::play){

            public void method_25354(class_1144 ignore) {
            }
        };
        this.playButton.field_22763 = enablePlay;
        this.children.add((class_339)this.playButton);
    }

    public void method_16014(double mouseX, double mouseY) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            child.method_16014(mouseX, mouseY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25402(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25406(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        class_339 child = this.findChild(mouseX, mouseY);
        if (child != null) {
            return child.method_25401(mouseX, mouseY, amount);
        }
        return false;
    }

    private class_339 findChild(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            for (class_339 e : this.children) {
                if (!e.method_25405(mouseX, mouseY)) continue;
                return e;
            }
        }
        return null;
    }

    public void method_25343(class_4587 matrixStack, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick_) {
        class_327 font = GameUtils.getTextRenderer();
        float f = rowTop;
        Objects.requireNonNull(font);
        float labelY = f + (float)(rowHeight - 9) / 2.0f;
        String text = this.config.soundEventId.toString();
        font.method_1729(matrixStack, text, (float)rowLeft, labelY, ColorPalette.WHITE.getRGB());
        int rightMargin = rowLeft + rowWidth;
        this.volume.field_22760 = rightMargin - this.volume.method_25368();
        this.volume.field_22761 = rowTop;
        this.volume.setHeight(rowHeight);
        this.playButton.field_22760 = (rightMargin -= this.volume.method_25368() + 3) - this.playButton.method_25368();
        this.playButton.field_22761 = rowTop;
        this.playButton.setHeight(rowHeight);
        this.blockButton.field_22760 = (rightMargin -= this.playButton.method_25368() + 3) - this.blockButton.method_25368();
        this.blockButton.field_22761 = rowTop;
        this.blockButton.setHeight(rowHeight);
        this.cullButton.field_22760 = (rightMargin -= this.blockButton.method_25368() + 3) - this.cullButton.method_25368();
        this.cullButton.setHeight(rowHeight);
        this.cullButton.field_22761 = rowTop;
        for (class_339 w : this.children) {
            w.method_25394(matrixStack, mouseX, mouseY, partialTick_);
        }
    }

    protected void toggleBlock(class_4185 button) {
        this.config.block = !this.config.block;
        button.method_25355(this.config.block ? BLOCK_ON : BLOCK_OFF);
    }

    protected void toggleCull(class_4185 button) {
        this.config.cull = !this.config.cull;
        button.method_25355(this.config.cull ? CULL_ON : CULL_OFF);
    }

    protected void play(class_4185 button) {
        if (this.soundPlay == null) {
            this.soundPlay = SoundLibraryHelpers.playSound(this.config);
            button.method_25355(STOP);
        } else {
            SoundLibraryHelpers.stopSound(this.soundPlay);
            this.soundPlay = null;
            button.method_25355(PLAY);
        }
    }

    @Override
    public void close() {
        if (this.soundPlay != null) {
            SoundLibraryHelpers.stopSound(this.soundPlay);
            this.soundPlay = null;
        }
    }

    public void tick() {
        if (this.soundPlay != null && !SoundLibraryHelpers.isPlaying(this.soundPlay)) {
            this.soundPlay = null;
            this.playButton.method_25355(PLAY);
        }
    }

    protected List<class_5481> getToolTip(int mouseX, int mouseY) {
        if (this.cachedToolTip.size() == 0) {
            class_2960 id = this.config.soundEventId;
            String mod = FrameworkUtils.getModDisplayName(id.method_12836());
            assert (mod != null);
            class_5481 modName = class_5481.method_30747((String)class_124.method_539((String)mod), (class_2583)modNameStyle);
            class_5481 soundLocationId = class_5481.method_30747((String)this.config.soundEventId.toString(), (class_2583)idStyle);
            this.cachedToolTip.add(modName);
            this.cachedToolTip.add(soundLocationId);
            SoundMetadata metadata = SoundLibrary.getSoundMetadata(id);
            if (metadata != null) {
                if (metadata.getTitle() != class_2585.field_24366) {
                    this.cachedToolTip.add(metadata.getTitle().method_30937());
                }
                if (metadata.getCaption() != class_2585.field_24366) {
                    this.cachedToolTip.add(new class_2588("dsurround.text.soundconfig.caption", new Object[]{metadata.getCaption()}).method_30937());
                }
                for (class_2561 t : metadata.getCredits()) {
                    this.cachedToolTip.add(t.method_30937());
                }
            }
            if (id.method_12836().equals("minecraft")) {
                this.cachedToolTip.add(VANILLA_CREDIT);
            }
        }
        ArrayList<class_5481> generatedTip = new ArrayList<class_5481>(this.cachedToolTip);
        Collection<class_5481> toAppend = null;
        if (this.volume.method_25405(mouseX, mouseY)) {
            toAppend = VOLUME_HELP;
        } else if (this.blockButton.method_25405(mouseX, mouseY)) {
            toAppend = BLOCK_HELP;
        } else if (this.cullButton.method_25405(mouseX, mouseY)) {
            toAppend = CULL_HELP;
        } else if (this.playButton.method_25405(mouseX, mouseY)) {
            toAppend = PLAY_HELP;
        }
        if (toAppend != null) {
            generatedTip.add(class_5481.field_26385);
            generatedTip.addAll(toAppend);
        }
        return generatedTip;
    }

    public IndividualSoundConfigEntry getData() {
        return this.config;
    }
}

