/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.gui.sound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.gui.sound.IndividualSoundControlListEntry;
import org.orecruncher.dsurround.gui.sound.SoundLibraryHelpers;

@Environment(value=EnvType.CLIENT)
public class IndividualSoundControlList
extends class_350<IndividualSoundControlListEntry> {
    private final class_437 parent;
    private final boolean enablePlay;
    private final int width;
    private List<IndividualSoundConfigEntry> source;
    private String lastSearchText = null;

    public IndividualSoundControlList(class_437 parent, class_310 mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotWidth, int slotHeightIn, boolean enablePlay, Supplier<String> filter, @Nullable IndividualSoundControlList oldList) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.parent = parent;
        this.enablePlay = enablePlay;
        this.width = slotWidth;
        if (oldList != null) {
            this.source = oldList.source;
        }
        this.setSearchFilter(filter, false);
    }

    public int method_25322() {
        return this.width;
    }

    protected int method_25329() {
        return (this.parent.field_22789 + this.method_25322()) / 2 + 20;
    }

    public void setSearchFilter(Supplier<String> filterBy, boolean forceReload) {
        String filter = filterBy.get();
        if (!forceReload && this.lastSearchText != null && this.lastSearchText.equals(filter)) {
            return;
        }
        this.lastSearchText = filter;
        this.method_25339();
        if (this.source == null || forceReload) {
            this.source = new ArrayList<IndividualSoundConfigEntry>(SoundLibraryHelpers.getSortedSoundConfigurations());
        }
        Function<IndividualSoundConfigEntry, Boolean> process = filter == null || filter.length() == 0 ? isc -> true : isc -> isc.soundEventId.toString().contains(filter);
        IndividualSoundControlListEntry first = null;
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!process.apply(cfg).booleanValue()) continue;
            IndividualSoundControlListEntry entry = new IndividualSoundControlListEntry(cfg, this.enablePlay);
            if (first == null) {
                first = entry;
            }
            this.method_25321(entry);
        }
        if (first != null) {
            this.method_25328(first);
        }
    }

    @Nullable
    public IndividualSoundControlListEntry getEntryAt(int mouseX, int mouseY) {
        return (IndividualSoundControlListEntry)this.method_25308(mouseX, mouseY);
    }

    public void tick() {
        this.method_25396().forEach(IndividualSoundControlListEntry::tick);
    }

    protected Collection<IndividualSoundConfigEntry> getConfigs() {
        ArrayList<IndividualSoundConfigEntry> configs = new ArrayList<IndividualSoundConfigEntry>();
        for (IndividualSoundConfigEntry cfg : this.source) {
            if (!cfg.isNotDefault()) continue;
            configs.add(cfg);
        }
        return configs;
    }

    public void saveChanges() {
        Client.SoundConfig.saveIndividualSoundConfigs(this.getConfigs());
    }

    public void method_37020(class_6382 builder) {
    }
}

