/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.eventing.handlers;

import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_310;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.eventing.ClientEventHooks;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.math.LoggingTimerEMA;
import org.orecruncher.dsurround.lib.math.TimerEMA;

@Environment(value=EnvType.CLIENT)
public final class DiagnosticHandler {
    private static final LoggingTimerEMA diagnostics = new LoggingTimerEMA("Diagnostics");
    private static final ObjectArray<String> left = new ObjectArray(16);
    private static final ObjectArray<String> right = new ObjectArray(16);
    private static boolean enableCollection = false;

    public static void toggleCollection() {
        enableCollection = !enableCollection;
        left.clear();
        right.clear();
    }

    public static boolean isCollecting() {
        return enableCollection;
    }

    public static ObjectArray<String> getLeft() {
        return left;
    }

    public static ObjectArray<String> getRight() {
        return right;
    }

    private static void tick(class_310 client) {
        if (enableCollection && GameUtils.isInGame()) {
            diagnostics.begin();
            left.clear();
            right.clear();
            left.add(Client.Branding);
            ObjectArray<TimerEMA> timers = new ObjectArray<TimerEMA>(8);
            ObjectArray<String> temp = new ObjectArray<String>(16);
            ((ClientEventHooks.CollectDiagnosticsEvent)ClientEventHooks.COLLECT_DIAGNOSTICS.invoker()).onCollect(left, temp, timers);
            right.add(class_124.field_1076 + diagnostics.toString());
            if (timers.size() > 0) {
                for (TimerEMA timer : timers) {
                    right.add(class_124.field_1076 + timer.toString());
                }
                right.add("");
            }
            right.addAll((Collection<String>)temp);
            diagnostics.end();
        }
    }

    static {
        ClientTickEvents.END_CLIENT_TICK.register(DiagnosticHandler::tick);
    }
}

