/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import org.orecruncher.dsurround.effects.IEntityEffect;

@Environment(value=EnvType.CLIENT)
public class EntityEffectInfo {
    private final WeakReference<class_1309> entity;
    private final Collection<IEntityEffect> effects;
    private final int version;

    public EntityEffectInfo(int version, class_1309 entity, Collection<IEntityEffect> effects) {
        this.version = version;
        this.entity = new WeakReference<class_1309>(entity);
        this.effects = effects;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDefault() {
        return false;
    }

    public Optional<class_1309> getEntity() {
        return Optional.ofNullable((class_1309)this.entity.get());
    }

    public void activate() {
        for (IEntityEffect e : this.effects) {
            e.activate(this);
        }
    }

    public void deactivate() {
        for (IEntityEffect e : this.effects) {
            e.deactivate(this);
        }
    }

    public void tick() {
        for (IEntityEffect e : this.effects) {
            e.tick(this);
        }
    }

    public Collection<IEntityEffect> getEffects() {
        return this.effects;
    }

    public boolean isVisibleTo(class_1657 player) {
        return ((class_1309)this.entity.get()).method_5756(player);
    }

    public boolean isAlive() {
        class_1309 temp = (class_1309)this.entity.get();
        return temp != null && temp.method_5805();
    }

    public boolean isWithinDistance(class_1309 entity, int distance) {
        return entity.method_24515().method_19771((class_2382)((class_1309)this.entity.get()).method_24515(), (double)distance);
    }
}

