/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.entity.EntityEffectBase;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.effects.particles.FrostBreathParticle;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.lib.random.MurmurHash3;
import org.orecruncher.dsurround.lib.world.WorldUtils;

@Environment(value=EnvType.CLIENT)
public class BreathEffect
extends EntityEffectBase {
    private int seed;

    @Override
    public void activate(EntityEffectInfo info) {
        this.seed = MurmurHash3.hash(info.getEntity().get().method_5628()) & 0xFFFF;
    }

    @Override
    public void tick(EntityEffectInfo info) {
        class_1309 entity = info.getEntity().get();
        if (this.isBreathVisible(entity)) {
            int c = (int)(TickCounter.getTickCount() + (long)this.seed);
            class_2338 headPos = this.getHeadPosition(entity);
            class_2680 state = entity.method_5770().method_8320(headPos);
            if (this.showWaterBubbles(state)) {
                int air = entity.method_5669();
                if (air > 0) {
                    int interval = c % 3;
                    if (interval == 0) {
                        this.createBubbleParticle(false);
                    }
                } else if (air == 0) {
                    for (int i = 0; i < 8; ++i) {
                        this.createBubbleParticle(true);
                    }
                }
            } else {
                int interval = c / 10 % 8;
                if (interval < 3 && this.showFrostBreath(entity, state, headPos)) {
                    this.createFrostParticle(entity);
                }
            }
        }
    }

    protected boolean isBreathVisible(class_1309 entity) {
        class_1657 player = GameUtils.getPlayer();
        if (entity == player) {
            return !player.method_7325() && !GameUtils.getGameSettings().field_1842;
        }
        return !entity.method_5756(player) && entity.method_6057((class_1297)player);
    }

    protected class_2338 getHeadPosition(class_1309 entity) {
        double d0 = entity.method_23320();
        return new class_2338(entity.method_23317(), d0, entity.method_23321());
    }

    protected boolean showWaterBubbles(class_2680 headBlock) {
        return headBlock.method_26207().method_15797();
    }

    protected boolean showFrostBreath(class_1309 entity, class_2680 headBlock, class_2338 pos) {
        if (headBlock.method_26207() == class_3614.field_15959) {
            class_1937 world = entity.method_5770();
            return WorldUtils.isColdTemperature(WorldUtils.getTemperatureAt(world, pos));
        }
        return false;
    }

    protected void createBubbleParticle(boolean isDrowning) {
    }

    protected void createFrostParticle(class_1309 entity) {
        FrostBreathParticle particle = new FrostBreathParticle(entity);
        this.addParticle((class_703)particle);
    }
}

