/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3614;
import net.minecraft.class_5431;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.WaterSplashJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public class WaterSplashProducer
extends BlockEffectProducer {
    private static final class_2382[] cardinal_offsets = new class_2382[]{new class_2382(-1, 0, 0), new class_2382(1, 0, 0), new class_2382(0, 0, -1), new class_2382(0, 0, 1)};

    public WaterSplashProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    private static boolean isUnboundedLiquid(class_1937 provider, class_2338 pos) {
        for (class_2382 cardinal_offset : cardinal_offsets) {
            class_2338 tp = pos.method_10081(cardinal_offset);
            class_2680 state = provider.method_8320(tp);
            if (state.method_26207() == class_3614.field_15959) {
                return true;
            }
            class_3610 fluidState = state.method_26227();
            int height = fluidState.method_15761();
            if (height <= 0 || height >= 8) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundedLiquid(class_1937 provider, class_2338 pos) {
        for (class_2382 cardinal_offset : cardinal_offsets) {
            class_2338 tp = pos.method_10081(cardinal_offset);
            class_2680 state = provider.method_8320(tp);
            if (state.method_26207() == class_3614.field_15959) {
                return false;
            }
            class_3610 fluidState = state.method_26227();
            if (fluidState.method_15769()) continue;
            if (((Boolean)fluidState.method_11654((class_2769)class_3609.field_15902)).booleanValue()) {
                return false;
            }
            int height = fluidState.method_15761();
            if (height <= 0 || height >= 8) continue;
            return false;
        }
        return true;
    }

    private int liquidBlockCount(class_1937 provider, class_2338 pos) {
        return WaterSplashProducer.countVerticalBlocks(provider, pos, FLUID_PREDICATE, 1);
    }

    public static boolean isValidSpawnBlock(class_1937 provider, class_2338 pos) {
        return WaterSplashProducer.isValidSpawnBlock(provider, provider.method_8320(pos), pos);
    }

    private static boolean isValidSpawnBlock(class_1937 provider, class_2680 state, class_2338 pos) {
        if (state.method_26227().method_15769()) {
            return false;
        }
        if (provider.method_8316(pos.method_10084()).method_15769()) {
            return false;
        }
        if (WaterSplashProducer.isUnboundedLiquid(provider, pos)) {
            class_2338 down = pos.method_10074();
            class_2680 downState = provider.method_8320(down);
            boolean solid = downState.method_30368((class_1922)provider, down, class_2350.field_11036, class_5431.field_25822);
            if (solid) {
                return true;
            }
            return WaterSplashProducer.isBoundedLiquid(provider, down);
        }
        return false;
    }

    @Override
    protected boolean canTrigger(class_1937 provider, class_2680 state, class_2338 pos, Random random) {
        return super.canTrigger(provider, state, pos, random) && WaterSplashProducer.isValidSpawnBlock(provider, state, pos);
    }

    @Override
    protected Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        int strength = this.liquidBlockCount(world, pos);
        if (strength > 1) {
            float height = state.method_26227().method_15763((class_1922)world, pos) + 0.1f;
            WaterSplashJetEffect effect = new WaterSplashJetEffect(strength, world, pos, (double)height);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

