/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3614;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.BubbleJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public class UnderwaterBubbleProducer
extends BlockEffectProducer {
    public UnderwaterBubbleProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        if (WATER_PREDICATE.test(state)) {
            class_2680 belowBlock = world.method_8320(pos.method_10074());
            class_3614 material = belowBlock.method_26207();
            boolean isSolidBlock = material.method_15799();
            return isSolidBlock && super.canTrigger(world, state, pos, random);
        }
        return false;
    }

    @Override
    protected Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        int liquidBlocks = UnderwaterBubbleProducer.countVerticalBlocks(world, pos, WATER_PREDICATE, 1);
        if (liquidBlocks > 0) {
            BubbleJetEffect effect = new BubbleJetEffect(liquidBlocks, world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

