/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.SteamJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public class SteamColumnProducer
extends BlockEffectProducer {
    public SteamColumnProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    public static boolean isValidSpawnBlock(class_1937 world, class_2338 pos, class_2680 source) {
        class_2680 whatsUp = world.method_8320(pos.method_10084());
        if (!whatsUp.method_26215()) {
            return false;
        }
        if (world.method_8320(pos) != source) {
            return false;
        }
        return SteamColumnProducer.countCubeBlocks(world, pos, HOTBLOCK_PREDICATE, true) > 0;
    }

    @Override
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, Random rand) {
        return SteamColumnProducer.isValidSpawnBlock(world, pos, state) && super.canTrigger(world, state, pos, rand);
    }

    @Override
    protected Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        int strength = SteamColumnProducer.countCubeBlocks(world, pos, HOTBLOCK_PREDICATE, false);
        if (strength > 0) {
            class_3610 fluidState = state.method_26227();
            float spawnHeight = fluidState.method_15769() ? (float)pos.method_10264() + 0.9f : (float)pos.method_10264() + fluidState.method_20785() + 0.1f;
            SteamJetEffect effect = new SteamJetEffect(strength, world, (double)pos.method_10263() + 0.5, spawnHeight, (double)pos.method_10260() + 0.5);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

