/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks.producers;

import java.util.Optional;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.effects.blocks.FlameJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.BlockEffectProducer;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public class FlameJetProducer
extends BlockEffectProducer {
    public FlameJetProducer(Script chance, Script conditions) {
        super(chance, conditions);
    }

    @Override
    protected boolean canTrigger(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        return world.method_8320(pos.method_10084()).method_26215() && super.canTrigger(world, state, pos, random);
    }

    @Override
    public Optional<IBlockEffect> produceImpl(class_1937 world, class_2680 state, class_2338 pos, Random random) {
        boolean isSolid;
        float spawnHeight;
        int blockCount;
        if (!state.method_26227().method_15769()) {
            blockCount = FlameJetProducer.countVerticalBlocks(world, pos, LAVA_PREDICATE, -1);
            spawnHeight = (float)pos.method_10264() + state.method_26227().method_20785() + 0.1f;
            isSolid = false;
        } else {
            class_265 shape = state.method_26218((class_1922)world, pos);
            if (shape.method_1110()) {
                return Optional.empty();
            }
            double blockHeight = shape.method_1107().field_1325;
            spawnHeight = (float)((double)pos.method_10264() + blockHeight);
            isSolid = true;
            blockCount = state.method_26207().method_15799() ? 2 : 1;
        }
        if (blockCount > 0) {
            FlameJetEffect effect = new FlameJetEffect(blockCount, world, (double)pos.method_10263() + 0.5, spawnHeight, (double)pos.method_10260() + 0.5, isSolid);
            return Optional.of(effect);
        }
        return Optional.empty();
    }
}

