/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.awt.Color;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4066;
import net.minecraft.class_703;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.effects.blocks.ParticleJetEffect;
import org.orecruncher.dsurround.effects.blocks.producers.WaterSplashProducer;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.sound.BackgroundSoundLoop;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;
import org.orecruncher.dsurround.sound.SoundInstanceHandler;

@Environment(value=EnvType.CLIENT)
public class WaterSplashJetEffect
extends ParticleJetEffect {
    private static final int THROTTLE_RANGE = 10;
    private static final ISoundFactory[] waterfallAcoustics = new ISoundFactory[11];
    protected BackgroundSoundLoop sound;
    protected int particleLimit;
    protected final double deltaY;
    protected final float red;
    protected final float green;
    protected final float blue;

    public WaterSplashJetEffect(int strength, class_1937 world, class_2338 loc, double dY) {
        super(0, strength, world, (double)loc.method_10263() + 0.5, (double)loc.method_10264() + 0.5, (double)loc.method_10260() + 0.5, 4);
        this.deltaY = (double)loc.method_10264() + dY;
        this.setSpawnCount((int)((float)strength * 2.5f));
        Color color = new Color(this.world.method_23753(this.position).method_8687());
        this.red = (float)color.getRed() / 255.0f;
        this.green = (float)color.getGreen() / 255.0f;
        this.blue = (float)color.getBlue() / 255.0f;
    }

    public void setSpawnCount(int limit) {
        this.particleLimit = class_3532.method_15340((int)limit, (int)5, (int)20);
    }

    public int getSpawnCount() {
        class_4066 state = GameUtils.getGameSettings().field_1882;
        return switch (state) {
            case class_4066.field_18199 -> 0;
            case class_4066.field_18197 -> this.particleLimit;
            default -> this.particleLimit / 2;
        };
    }

    @Override
    public boolean shouldDie() {
        return this.particleAge % 10 == 0 && !WaterSplashProducer.isValidSpawnBlock(this.world, this.position);
    }

    @Override
    protected void soundUpdate() {
        boolean isDone;
        if (!Client.Config.blockEffects.enableWaterfallSounds) {
            if (this.sound != null) {
                MinecraftAudioPlayer.INSTANCE.stop((class_1113)this.sound);
                this.sound = null;
            }
            return;
        }
        if (this.sound == null) {
            int idx = class_3532.method_15340((int)this.jetStrength, (int)0, (int)(waterfallAcoustics.length - 1));
            this.sound = waterfallAcoustics[idx].createBackgroundSoundLoopAt(this.position);
        }
        boolean inRange = SoundInstanceHandler.inRange(GameUtils.getPlayer().method_33571(), (class_1113)this.sound, 4);
        boolean bl = isDone = !MinecraftAudioPlayer.INSTANCE.isPlaying((class_1113)this.sound);
        if (inRange && isDone) {
            MinecraftAudioPlayer.INSTANCE.play((class_1113)this.sound);
        } else if (!inRange && !isDone) {
            MinecraftAudioPlayer.INSTANCE.stop((class_1113)this.sound);
        }
    }

    @Override
    protected void cleanUp() {
        if (this.sound != null) {
            MinecraftAudioPlayer.INSTANCE.stop((class_1113)this.sound);
            this.sound = null;
        }
        super.cleanUp();
    }

    @Override
    protected void spawnJetParticle() {
        if (!Client.Config.blockEffects.enableWaterfallParticles) {
            return;
        }
        int splashCount = this.getSpawnCount();
        int j = 0;
        while ((float)j < (float)splashCount) {
            double xOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
            double zOffset = RANDOM.nextFloat() * 2.0f - 1.0f;
            int motionStr = this.jetStrength;
            double motionX = xOffset * ((double)motionStr / 20.0);
            double motionZ = zOffset * ((double)motionStr / 20.0);
            double motionY = 0.1 + (double)(RANDOM.nextFloat() * (float)motionStr) / 20.0;
            class_703 particle = this.createParticle(class_2398.field_11202, this.posX + xOffset, this.deltaY, this.posZ + zOffset, motionX, motionY, motionZ);
            particle.method_34753(motionX, motionY, motionZ);
            particle.method_3077(particle.method_3082() * 2);
            this.addParticle(particle);
            ++j;
        }
    }

    static {
        ISoundFactory factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.0")).pitchRange(0.8f, 1.2f).build();
        Arrays.fill(waterfallAcoustics, factory);
        WaterSplashJetEffect.waterfallAcoustics[2] = WaterSplashJetEffect.waterfallAcoustics[3] = (factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.1")).pitchRange(0.8f, 1.2f).build());
        WaterSplashJetEffect.waterfallAcoustics[4] = factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.2")).pitchRange(0.8f, 1.2f).build();
        WaterSplashJetEffect.waterfallAcoustics[5] = WaterSplashJetEffect.waterfallAcoustics[6] = (factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.3")).pitchRange(0.8f, 1.2f).build());
        WaterSplashJetEffect.waterfallAcoustics[7] = WaterSplashJetEffect.waterfallAcoustics[8] = (factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.4")).pitchRange(0.8f, 1.2f).build());
        WaterSplashJetEffect.waterfallAcoustics[9] = WaterSplashJetEffect.waterfallAcoustics[10] = (factory = SoundFactoryBuilder.create(new class_2960("dsurround", "waterfall.5")).pitchRange(0.8f, 1.2f).build());
    }
}

