/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import org.orecruncher.dsurround.effects.blocks.BlockEffectBase;

@Environment(value=EnvType.CLIENT)
public abstract class ParticleJetEffect
extends BlockEffectBase {
    protected final int jetStrength;
    protected final int updateFrequency;
    protected final int particleMaxAge;
    protected int particleAge;

    public ParticleJetEffect(int strength, class_1937 world, double x, double y, double z) {
        this(0, strength, world, x, y, z, 3);
    }

    public ParticleJetEffect(int layer, int strength, class_1937 world, double x, double y, double z, int freq) {
        super(world, x, y, z);
        this.jetStrength = strength;
        this.updateFrequency = freq;
        this.particleMaxAge = (RANDOM.nextInt(strength) + 2) * 20;
    }

    protected abstract void spawnJetParticle();

    @Override
    public boolean shouldDie() {
        return this.particleAge >= this.particleMaxAge;
    }

    @Override
    public void think() {
        if (this.particleAge % this.updateFrequency == 0) {
            this.spawnJetParticle();
        }
        ++this.particleAge;
    }
}

