/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_3417;
import net.minecraft.class_687;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.blocks.ParticleJetEffect;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.MinecraftAudioPlayer;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Environment(value=EnvType.CLIENT)
public class FlameJetEffect
extends ParticleJetEffect {
    private static final ISoundFactory FIRE_AMBIENT = SoundFactoryBuilder.create(class_3417.field_14993).build();
    protected final boolean isLava;
    protected final class_2400 particleType;
    protected final boolean isSolid;
    protected boolean soundFired;

    public FlameJetEffect(int strength, class_1937 world, double x, double y, double z, boolean isSolid) {
        super(strength, world, x, y, z);
        this.isLava = !isSolid && RANDOM.nextInt(3) == 0;
        this.particleType = this.isLava ? class_2398.field_11239 : class_2398.field_11240;
        this.isSolid = isSolid;
    }

    @Override
    protected void soundUpdate() {
        if (!this.soundFired) {
            this.soundFired = true;
            if (this.jetStrength > 1) {
                class_1109 soundInstance = FIRE_AMBIENT.createAtLocation(this.getPos());
                MinecraftAudioPlayer.INSTANCE.play((class_1113)soundInstance);
            }
        }
    }

    @Override
    protected void spawnJetParticle() {
        class_703 particle;
        double speedY = this.isLava ? 0.0 : (double)this.jetStrength / 10.0;
        float scale = this.jetStrength;
        double x = this.posX;
        double z = this.posZ;
        if (this.isSolid) {
            x += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            z += (RANDOM.nextDouble() - RANDOM.nextDouble()) * 0.5;
            if (this.jetStrength == 1) {
                speedY *= 0.5;
                scale *= 0.5f;
            }
        }
        if ((particle = this.createParticle(this.particleType, x, this.posY, z, 0.0, speedY, 0.0)) instanceof class_687) {
            particle.method_3087(scale);
        }
        this.addParticle(particle);
    }
}

