/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.effects.blocks;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_703;
import org.orecruncher.dsurround.effects.IBlockEffect;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;
import org.orecruncher.dsurround.mixins.core.MixinParticleManager;

@Environment(value=EnvType.CLIENT)
public abstract class BlockEffectBase
implements IBlockEffect {
    protected static final Random RANDOM = XorShiftRandom.current();
    protected final class_1937 world;
    protected final double posX;
    protected final double posY;
    protected final double posZ;
    protected final class_2338 position;
    private boolean isAlive = true;

    protected BlockEffectBase(class_1937 worldIn, double posXIn, double posYIn, double posZIn) {
        this.world = worldIn;
        this.posX = posXIn;
        this.posY = posYIn;
        this.posZ = posZIn;
        this.position = new class_2338(posXIn, posYIn, posZIn);
    }

    @Override
    public class_2338 getPos() {
        return this.position;
    }

    public void addParticle(class_703 particle) {
        GameUtils.getMC().field_1713.method_3058(particle);
    }

    public void addParticle(class_2394 parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        GameUtils.getMC().field_1713.method_3056(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    public <T extends class_2394> class_703 createParticle(T parameters, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        return ((MixinParticleManager)GameUtils.getMC().field_1713).dsurroundCreateParticle(parameters, x, y, z, velocityX, velocityY, velocityZ);
    }

    @Override
    public boolean isDone() {
        return !this.isAlive;
    }

    @Override
    public void setDone() {
        this.isAlive = false;
        this.cleanUp();
    }

    public boolean shouldDie() {
        return false;
    }

    protected void cleanUp() {
    }

    @Override
    public void tick() {
        if (this.shouldDie()) {
            this.setDone();
            return;
        }
        this.think();
        if (!this.isDone()) {
            this.soundUpdate();
        }
    }

    protected void soundUpdate() {
    }

    public abstract void think();
}

