/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.dimension;

import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.config.data.DimensionConfig;
import org.orecruncher.dsurround.lib.world.WorldUtils;

public class DimensionInfo {
    public static final DimensionInfo NONE = new DimensionInfo();
    private static final int SPACE_HEIGHT_OFFSET = 32;
    protected final boolean isFlatWorld;
    protected class_2960 name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;

    DimensionInfo() {
        this.name = new class_2960("dsurround", "no_dimension");
        this.isFlatWorld = false;
    }

    public DimensionInfo(class_1937 world, DimensionConfig dimConfig) {
        class_2874 dt = world.method_8597();
        this.name = world.method_27983().method_29177();
        this.seaLevel = world.method_8615();
        this.cloudHeight = this.skyHeight = world.method_31605();
        this.spaceHeight = this.skyHeight + 32;
        this.isFlatWorld = WorldUtils.isSuperFlat(world);
        if (this.isFlatWorld) {
            this.seaLevel = 0;
        }
        if (dimConfig != null) {
            dimConfig.seaLevel.ifPresent(v -> {
                this.seaLevel = v;
            });
            dimConfig.skyHeight.ifPresent(v -> {
                this.skyHeight = v;
            });
            dimConfig.alwaysOutside.ifPresent(v -> {
                this.alwaysOutside = v;
            });
            dimConfig.playBiomeSounds.ifPresent(v -> {
                this.playBiomeSounds = v;
            });
            dimConfig.cloudHeight.ifPresentOrElse(v -> {
                this.cloudHeight = v;
            }, () -> {
                this.cloudHeight = this.skyHeight / 2;
            });
            this.spaceHeight = this.skyHeight + 32;
        }
    }

    public class_2960 getName() {
        return this.name;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public int getSkyHeight() {
        return this.skyHeight;
    }

    public int getCloudHeight() {
        return this.cloudHeight;
    }

    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    public boolean playBiomeSounds() {
        return this.playBiomeSounds;
    }

    public boolean alwaysOutside() {
        return this.alwaysOutside;
    }

    public boolean isFlatWorld() {
        return this.isFlatWorld;
    }
}

