/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import org.orecruncher.dsurround.config.EntityEffectType;
import org.orecruncher.dsurround.config.EntityTypeMatcher;
import org.orecruncher.dsurround.lib.IMatcher;

@Environment(value=EnvType.CLIENT)
public class EntityEffectConfigRule {
    public static Codec<EntityEffectConfigRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(EntityTypeMatcher.CODEC).fieldOf("entityTypes").forGetter(info -> info.entityTypeMatchers), (App)Codec.list(EntityEffectType.CODEC).fieldOf("effects").forGetter(info -> info.effects)).apply((Applicative)instance, EntityEffectConfigRule::new));
    public final List<IMatcher<class_1297>> entityTypeMatchers;
    public final List<EntityEffectType> effects;

    private static DataResult<class_1299<?>> manifestEntityType(String entityTypeId) {
        try {
            Optional type = class_1299.method_5898((String)entityTypeId);
            return type.map(DataResult::success).orElseGet(() -> DataResult.error((String)String.format("Unknown entity type id %s", entityTypeId)));
        }
        catch (Throwable t) {
            return DataResult.error((String)t.getMessage());
        }
    }

    EntityEffectConfigRule(List<IMatcher<class_1297>> entityTypeMatchers, List<EntityEffectType> effects) {
        this.entityTypeMatchers = entityTypeMatchers;
        this.effects = effects;
    }

    public boolean match(class_1309 entity) {
        for (IMatcher<class_1297> rule : this.entityTypeMatchers) {
            if (!rule.match((class_1297)entity)) continue;
            return true;
        }
        return false;
    }
}

