/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;
import org.orecruncher.dsurround.config.AcousticConfig;
import org.orecruncher.dsurround.config.data.BlockEffectConfig;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public class BlockConfigRule {
    public static Codec<BlockConfigRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(CodecExtensions.checkBlockStateSpecification(true, true)).fieldOf("blocks").forGetter(info -> info.blocks), (App)Codec.BOOL.optionalFieldOf("clearSounds", (Object)false).forGetter(info -> info.clearSounds), (App)Script.CODEC.optionalFieldOf("soundChance").forGetter(info -> info.soundChance), (App)Codec.FLOAT.optionalFieldOf("soundReflectivity").forGetter(info -> info.soundReflectivity), (App)Codec.FLOAT.optionalFieldOf("soundOcclusion").forGetter(info -> info.soundOcclusion), (App)Codec.list(AcousticConfig.CODEC).optionalFieldOf("acoustics", (Object)ImmutableList.of()).forGetter(info -> info.acoustics), (App)Codec.list(BlockEffectConfig.CODEC).optionalFieldOf("effects", (Object)ImmutableList.of()).forGetter(info -> info.effects)).apply((Applicative)instance, BlockConfigRule::new));
    public List<IMatcher<class_2680>> blocks;
    public boolean clearSounds;
    public Optional<Script> soundChance;
    public Optional<Float> soundReflectivity;
    public Optional<Float> soundOcclusion;
    public List<AcousticConfig> acoustics;
    public List<BlockEffectConfig> effects;

    BlockConfigRule(List<IMatcher<class_2680>> blocks, boolean soundReset, Optional<Script> chance, Optional<Float> soundReflectivity, Optional<Float> soundOcclusion, List<AcousticConfig> acoustics, List<BlockEffectConfig> effects) {
        this.blocks = blocks;
        this.clearSounds = soundReset;
        this.soundChance = chance;
        this.soundReflectivity = soundReflectivity;
        this.soundOcclusion = soundOcclusion;
        this.acoustics = acoustics;
        this.effects = effects;
    }

    public boolean match(class_2680 state) {
        for (IMatcher<class_2680> rule : this.blocks) {
            if (!rule.match(state)) continue;
            return true;
        }
        return false;
    }
}

