/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.block;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3614;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.config.AcousticConfig;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.config.biome.AcousticEntry;
import org.orecruncher.dsurround.config.data.BlockConfigRule;
import org.orecruncher.dsurround.config.data.BlockEffectConfig;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.lib.WeightTable;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.material.MaterialUtils;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.ConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Environment(value=EnvType.CLIENT)
public class BlockInfo {
    private static final float DEFAULT_OPAQUE_OCCLUSION = 0.5f;
    private static final float DEFAULT_TRANSLUCENT_OCCLUSION = 0.15f;
    private static final float DEFAULT_REFLECTION = 0.4f;
    @Nullable
    protected ObjectArray<AcousticEntry> sounds;
    @Nullable
    protected ObjectArray<IBlockEffectProducer> blockEffects;
    @Nullable
    protected ObjectArray<IBlockEffectProducer> alwaysOnEffects;
    protected final int version;
    protected final class_3614 material;
    protected Script soundChance = new Script("0.01");
    protected float soundReflectivity = 0.4f;
    protected float soundOcclusion = 0.5f;

    public BlockInfo(int version) {
        this.version = version;
        this.material = class_3614.field_15959;
    }

    public BlockInfo(int version, class_2680 state) {
        this.version = version;
        this.soundOcclusion = state.method_26207().method_15804() ? 0.5f : 0.15f;
        this.material = state.method_26207();
    }

    public boolean isDefault() {
        return this.sounds == null && this.blockEffects == null && this.alwaysOnEffects == null && this.soundReflectivity == 0.4f && (this.soundOcclusion == 0.5f || this.soundOcclusion == 0.15f);
    }

    public int getVersion() {
        return this.version;
    }

    public float getSoundReflectivity() {
        return this.soundReflectivity;
    }

    public float getSoundOcclusion() {
        return this.soundOcclusion;
    }

    private void addToSounds(AcousticEntry entry) {
        if (this.sounds == null) {
            this.sounds = new ObjectArray(4);
        }
        this.sounds.add(entry);
    }

    private void addToBlockEffects(IBlockEffectProducer effect) {
        if (this.blockEffects == null) {
            this.blockEffects = new ObjectArray(2);
        }
        this.blockEffects.add(effect);
    }

    private void addToAlwaysOnEffects(IBlockEffectProducer effect) {
        if (this.alwaysOnEffects == null) {
            this.alwaysOnEffects = new ObjectArray(2);
        }
        this.alwaysOnEffects.add(effect);
    }

    public void update(BlockConfigRule config) {
        if (config.clearSounds) {
            this.clearSounds();
        }
        config.soundChance.ifPresent(v -> {
            this.soundChance = v;
        });
        config.soundReflectivity.ifPresent(v -> {
            this.soundReflectivity = v.floatValue();
        });
        config.soundOcclusion.ifPresent(v -> {
            this.soundOcclusion = v.floatValue();
        });
        for (AcousticConfig sr : config.acoustics) {
            if (sr.soundEventId == null) continue;
            class_2960 res = SoundLibrary.resolveIdentifier("dsurround", sr.soundEventId);
            class_3414 acoustic = SoundLibrary.getSound(res);
            ISoundFactory factory = SoundFactoryBuilder.create(acoustic).category(sr.category).volumeRange(sr.minVolume, sr.maxVolume).pitchRange(sr.minPitch, sr.maxPitch).build();
            AcousticEntry acousticEntry = new AcousticEntry(factory, sr.conditions, sr.weight);
            this.addToSounds(acousticEntry);
        }
        for (BlockEffectConfig e : config.effects) {
            Optional<IBlockEffectProducer> effect = e.effect.getInstance(e.spawnChance, e.conditions);
            effect.ifPresent(t -> {
                if (e.alwaysOn) {
                    this.addToAlwaysOnEffects((IBlockEffectProducer)t);
                } else {
                    this.addToBlockEffects((IBlockEffectProducer)t);
                }
            });
        }
    }

    private void clearSounds() {
        if (this.sounds != null) {
            this.sounds.clear();
        }
    }

    public boolean hasSoundsOrEffects() {
        return this.sounds != null || this.blockEffects != null;
    }

    public boolean hasAlwaysOnEffects() {
        return this.alwaysOnEffects != null;
    }

    public ISoundFactory getSoundToPlay(Random random) {
        Object chance;
        if (this.sounds != null && (chance = ConditionEvaluator.INSTANCE.eval(this.soundChance)) instanceof Double) {
            Double c = (Double)chance;
            if (random.nextDouble() < c) {
                Stream<AcousticEntry> candidates = this.sounds.stream().filter(AcousticEntry::matches);
                return (ISoundFactory)WeightTable.makeSelection(candidates);
            }
        }
        return null;
    }

    public Collection<IBlockEffectProducer> getEffectProducers() {
        return this.blockEffects == null ? ImmutableList.of() : this.blockEffects;
    }

    public Collection<IBlockEffectProducer> getAlwaysOnEffectProducers() {
        return this.alwaysOnEffects == null ? ImmutableList.of() : this.alwaysOnEffects;
    }

    public void trim() {
        if (this.sounds != null) {
            if (this.sounds.size() == 0) {
                this.sounds = null;
            } else {
                this.sounds.trim();
            }
        }
        if (this.alwaysOnEffects != null) {
            if (this.alwaysOnEffects.size() == 0) {
                this.alwaysOnEffects = null;
            } else {
                this.alwaysOnEffects.trim();
            }
        }
        if (this.blockEffects != null) {
            if (this.blockEffects.size() == 0) {
                this.blockEffects = null;
            } else {
                this.blockEffects.trim();
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("material: ").append(MaterialUtils.getMaterialName(this.material));
        builder.append("; reflectivity: ").append(this.soundReflectivity).append("; occlusion: ").append(this.soundOcclusion).append("\n");
        if (this.sounds != null) {
            builder.append("sound chance: ").append(this.soundChance);
            builder.append("; sounds [\n");
            builder.append(this.sounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]\n");
        }
        if (this.blockEffects != null) {
            builder.append("random effects [\n");
            builder.append(this.blockEffects.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]\n");
        }
        if (this.alwaysOnEffects != null) {
            builder.append("always on effects [\n");
            builder.append(this.alwaysOnEffects.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        return builder.toString();
    }
}

