/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome.biometraits;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeCategoryAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeClimateAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeDeepAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeGeographyAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeMysticalAnalyzer;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTrait;
import org.orecruncher.dsurround.config.biome.biometraits.IBiomeTraitAnalyzer;
import org.orecruncher.dsurround.lib.collections.ObjectArray;

public final class BiomeTraits {
    private static final ObjectArray<IBiomeTraitAnalyzer> traitAnalyzer = new ObjectArray(16);
    private final Set<BiomeTrait> traits;

    BiomeTraits(Collection<BiomeTrait> traits) {
        this.traits = new HashSet<BiomeTrait>(traits);
    }

    public static BiomeTraits createFrom(class_2960 id, class_1959 biome) {
        List<BiomeTrait> traits = traitAnalyzer.stream().map(analyzer -> analyzer.evaluate(id, biome)).flatMap(Collection::stream).collect(Collectors.toList());
        return new BiomeTraits(traits);
    }

    public static BiomeTraits from(BiomeTrait ... traits) {
        return new BiomeTraits(List.of(traits));
    }

    public boolean contains(String trait) {
        return this.contains(BiomeTrait.of(trait));
    }

    public boolean contains(BiomeTrait trait) {
        return this.traits.contains((Object)trait);
    }

    public String toString() {
        String temp = this.traits.stream().map(BiomeTrait::getName).collect(Collectors.joining(","));
        return String.format("Traits [%s]", temp);
    }

    static {
        traitAnalyzer.add(new BiomeCategoryAnalyzer());
        traitAnalyzer.add(new BiomeClimateAnalyzer());
        traitAnalyzer.add(new BiomeDeepAnalyzer());
        traitAnalyzer.add(new BiomeGeographyAnalyzer());
        traitAnalyzer.add(new BiomeMysticalAnalyzer());
    }
}

