/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome.biometraits;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1959;

public enum BiomeTrait {
    UNKNOWN("UNKNOWN"),
    FAKE("FAKE"),
    INSIDE("inside"),
    VILLAGE("VILLAGE"),
    PLAYER("PLAYER"),
    SPACE("SPACE"),
    CLOUDS("CLOUDS"),
    UNDER_RIVER("UNDER_RIVER"),
    UNDER_WATER("UNDER_WATER"),
    UNDER_OCEAN("UNDER_OCEAN"),
    NONE(class_1959.class_1961.field_9371.method_8749()),
    TAIGA(class_1959.class_1961.field_9361.method_8749()),
    EXTREME_HILLS(class_1959.class_1961.field_9357.method_8749()),
    JUNGLE(class_1959.class_1961.field_9358.method_8749()),
    MESA(class_1959.class_1961.field_9354.method_8749()),
    PLAINS(class_1959.class_1961.field_9355.method_8749()),
    SAVANNA(class_1959.class_1961.field_9356.method_8749()),
    ICY(class_1959.class_1961.field_9362.method_8749()),
    THEEND(class_1959.class_1961.field_9360.method_8749()),
    BEACH(class_1959.class_1961.field_9363.method_8749()),
    FOREST(class_1959.class_1961.field_9370.method_8749()),
    OCEAN(class_1959.class_1961.field_9367.method_8749()),
    DESERT(class_1959.class_1961.field_9368.method_8749()),
    RIVER(class_1959.class_1961.field_9369.method_8749()),
    SWAMP(class_1959.class_1961.field_9364.method_8749()),
    MUSHROOM(class_1959.class_1961.field_9365.method_8749()),
    NETHER(class_1959.class_1961.field_9366.method_8749()),
    UNDERGROUND(class_1959.class_1961.field_29217.method_8749()),
    WATER("WATER"),
    WET("WET"),
    DRY("DRY"),
    HOT("HOT"),
    COLD("COLD"),
    SPARSE("SPARSE"),
    DENSE("DENSE"),
    CONIFEROUS("CONIFEROUS"),
    SPOOKY("SPOOKY"),
    DEAD("DEAD"),
    MAGICAL("MAGICAL"),
    PLATEAU("PLATEAU"),
    MOUNTAIN("MOUNTAIN"),
    HILLS("HILLS"),
    SANDY("SANDY"),
    SNOWY("SNOWY"),
    WASTELAND("WASTELAND"),
    VOID("VOID"),
    OVERWORLD("OVERWORLD"),
    DEEP("DEEP");

    private static final Map<String, BiomeTrait> mapper;
    private final String name;

    private BiomeTrait(String name) {
        this.name = name.toUpperCase();
    }

    public static BiomeTrait of(class_1959.class_1961 category) {
        BiomeTrait result = mapper.get(category.method_8749().toUpperCase());
        return result == null ? UNKNOWN : result;
    }

    public static BiomeTrait of(String name) {
        BiomeTrait result = mapper.get(name.toUpperCase());
        return result == null ? UNKNOWN : result;
    }

    private static void register(BiomeTrait trait) {
        mapper.put(trait.name, trait);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    static {
        mapper = new HashMap<String, BiomeTrait>();
        BiomeTrait.register(NONE);
        BiomeTrait.register(TAIGA);
        BiomeTrait.register(EXTREME_HILLS);
        BiomeTrait.register(JUNGLE);
        BiomeTrait.register(MESA);
        BiomeTrait.register(PLAINS);
        BiomeTrait.register(SAVANNA);
        BiomeTrait.register(ICY);
        BiomeTrait.register(THEEND);
        BiomeTrait.register(BEACH);
        BiomeTrait.register(FOREST);
        BiomeTrait.register(OCEAN);
        BiomeTrait.register(DESERT);
        BiomeTrait.register(RIVER);
        BiomeTrait.register(SWAMP);
        BiomeTrait.register(MUSHROOM);
        BiomeTrait.register(NETHER);
        BiomeTrait.register(UNDERGROUND);
        BiomeTrait.register(WATER);
        BiomeTrait.register(WET);
        BiomeTrait.register(DRY);
        BiomeTrait.register(HOT);
        BiomeTrait.register(COLD);
        BiomeTrait.register(SPARSE);
        BiomeTrait.register(DENSE);
        BiomeTrait.register(CONIFEROUS);
        BiomeTrait.register(SPOOKY);
        BiomeTrait.register(DEAD);
        BiomeTrait.register(MAGICAL);
        BiomeTrait.register(PLATEAU);
        BiomeTrait.register(MOUNTAIN);
        BiomeTrait.register(HILLS);
        BiomeTrait.register(SANDY);
        BiomeTrait.register(SNOWY);
        BiomeTrait.register(WASTELAND);
        BiomeTrait.register(VOID);
        BiomeTrait.register(OVERWORLD);
        BiomeTrait.register(DEEP);
    }
}

