/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome;

import java.awt.Color;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.AcousticConfig;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.SoundEventType;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.config.biome.AcousticEntry;
import org.orecruncher.dsurround.config.biome.IBiomeSoundProvider;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.config.data.BiomeConfigRule;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.WeightTable;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.gui.ColorPalette;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.ConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;
import org.orecruncher.dsurround.sound.SoundFactoryBuilder;

@Environment(value=EnvType.CLIENT)
public final class BiomeInfo
implements Comparable<BiomeInfo>,
IBiomeSoundProvider {
    public static final int DEFAULT_ADDITIONAL_SOUND_CHANCE = 250;
    public static final Script DEFAULT_SOUND_CHANCE = new Script(String.valueOf(0.004));
    private static final IModLog LOGGER = Client.LOGGER.createChild(BiomeInfo.class);
    private final int version;
    private final class_2960 biomeId;
    private final String biomeName;
    private final ObjectArray<AcousticEntry> loopSounds = new ObjectArray();
    private final ObjectArray<AcousticEntry> moodSounds = new ObjectArray();
    private final ObjectArray<AcousticEntry> additionalSounds = new ObjectArray();
    private final ObjectArray<AcousticEntry> musicSounds = new ObjectArray();
    private final BiomeTraits traits;
    private final boolean isRiver;
    private final boolean isOcean;
    private final boolean isDeepOcean;
    private Color fogColor;
    private Script additionalSoundChance = DEFAULT_SOUND_CHANCE;
    private Script moodSoundChance = DEFAULT_SOUND_CHANCE;
    private ObjectArray<String> comments;

    public BiomeInfo(int version, class_2960 id, String name, BiomeTraits traits) {
        this.version = version;
        this.biomeId = id;
        this.biomeName = name;
        this.traits = traits;
        this.isRiver = this.traits.contains("RIVER");
        this.isOcean = this.traits.contains("OCEAN");
        this.isDeepOcean = this.isOcean && this.traits.contains("DEEP");
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isRiver() {
        return this.isRiver;
    }

    public boolean isOcean() {
        return this.isOcean;
    }

    public boolean isDeepOcean() {
        return this.isDeepOcean;
    }

    public class_2960 getBiomeId() {
        return this.biomeId;
    }

    void addComment(String comment) {
        if (!StringUtils.isEmpty((CharSequence)comment)) {
            if (this.comments == null) {
                this.comments = new ObjectArray();
            }
            this.comments.add(comment);
        }
    }

    public String getBiomeName() {
        return this.biomeName;
    }

    public Color getFogColor() {
        return this.fogColor;
    }

    void setFogColor(Color color) {
        this.fogColor = color;
    }

    public boolean getHasFog() {
        return this.fogColor != null;
    }

    void setAdditionalSoundChance(Script chance) {
        this.additionalSoundChance = chance;
    }

    void setMoodSoundChance(Script chance) {
        this.moodSoundChance = chance;
    }

    public BiomeTraits getTraits() {
        return this.traits;
    }

    @Override
    public Collection<ISoundFactory> findBiomeSoundMatches() {
        ObjectArray<ISoundFactory> results = new ObjectArray<ISoundFactory>();
        for (AcousticEntry sound : this.loopSounds) {
            if (!sound.matches()) continue;
            results.add(sound.getAcoustic());
        }
        return results;
    }

    @Override
    @Nullable
    public ISoundFactory getExtraSound(SoundEventType type, Random random) {
        ObjectArray<AcousticEntry> sourceList = null;
        switch (type) {
            case ADDITION: {
                Object chance = ConditionEvaluator.INSTANCE.eval(this.additionalSoundChance);
                if (!(chance instanceof Double)) break;
                Double c = (Double)chance;
                sourceList = random.nextDouble() < c ? this.additionalSounds : null;
                break;
            }
            case MOOD: {
                Object chance = ConditionEvaluator.INSTANCE.eval(this.moodSoundChance);
                if (!(chance instanceof Double)) break;
                Double c = (Double)chance;
                sourceList = random.nextDouble() < c ? this.moodSounds : null;
                break;
            }
            case MUSIC: {
                sourceList = this.musicSounds;
            }
        }
        if (sourceList == null || sourceList.size() == 0) {
            return null;
        }
        Stream<AcousticEntry> candidates = sourceList.stream().filter(AcousticEntry::matches);
        return (ISoundFactory)WeightTable.makeSelection(candidates);
    }

    void clearSounds() {
        this.loopSounds.clear();
        this.additionalSounds.clear();
        this.musicSounds.clear();
        this.moodSounds.clear();
        this.moodSoundChance = DEFAULT_SOUND_CHANCE;
        this.additionalSoundChance = DEFAULT_SOUND_CHANCE;
    }

    public void update(BiomeConfigRule entry) {
        entry.comment.ifPresent(this::addComment);
        entry.fogColor.ifPresent(v -> this.setFogColor(ColorPalette.fromHTMLColorCode(v)));
        entry.additionalSoundChance.ifPresent(this::setAdditionalSoundChance);
        entry.moodSoundChance.ifPresent(this::setMoodSoundChance);
        if (entry.clearSounds) {
            this.addComment("> Sound Clear");
            this.clearSounds();
        }
        for (AcousticConfig sr : entry.acoustics) {
            class_2960 res = SoundLibrary.resolveIdentifier("dsurround", sr.soundEventId);
            class_3414 acoustic = SoundLibrary.getSound(res);
            ISoundFactory factory = SoundFactoryBuilder.create(acoustic).category(sr.category).volumeRange(sr.minVolume, sr.maxVolume).pitchRange(sr.minPitch, sr.maxPitch).build();
            switch (sr.type) {
                case LOOP: {
                    AcousticEntry acousticEntry = new AcousticEntry(factory, sr.conditions);
                    this.loopSounds.add(acousticEntry);
                    break;
                }
                case ADDITION: 
                case MOOD: 
                case MUSIC: {
                    int weight = sr.weight;
                    AcousticEntry acousticEntry = new AcousticEntry(factory, sr.conditions, weight);
                    if (sr.type == SoundEventType.ADDITION) {
                        this.additionalSounds.add(acousticEntry);
                        break;
                    }
                    if (sr.type == SoundEventType.MOOD) {
                        this.moodSounds.add(acousticEntry);
                        break;
                    }
                    this.musicSounds.add(acousticEntry);
                    break;
                }
                default: {
                    LOGGER.warn("Unknown SoundEventType %s", new Object[]{sr.type});
                }
            }
        }
    }

    public void trim() {
        this.loopSounds.trim();
        this.additionalSounds.trim();
        this.moodSounds.trim();
        this.musicSounds.trim();
        if (this.comments != null) {
            this.comments.trim();
        }
    }

    private class_1959 getBiome() {
        return BiomeLibrary.getBiome(this.biomeId);
    }

    public String toString() {
        String indent = "    ";
        String tags = this.biomeId.method_12836().equalsIgnoreCase("dsurround") ? "FAKE BIOME" : GameUtils.getWorld().method_8514().method_33164(class_2378.field_25114).method_30206((Object)this.getBiome()).stream().map(class_2960::toString).sorted().collect(Collectors.joining(","));
        StringBuilder builder = new StringBuilder();
        builder.append("Biome [").append(this.getBiomeName()).append('/').append(this.biomeId).append("]");
        builder.append("\nTags: ").append(tags);
        builder.append("\n").append(this.getTraits().toString());
        if (this.fogColor != null) {
            builder.append("\nfogColor: ").append(ColorPalette.toHTMLColorCode(this.fogColor));
        }
        if (this.loopSounds.size() > 0) {
            builder.append("\nLOOP sounds [\n");
            builder.append(this.loopSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (this.musicSounds.size() > 0) {
            builder.append("\nMUSIC sounds [\n");
            builder.append(this.musicSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (this.additionalSounds.size() > 0) {
            builder.append("\nADDITIONAL chance: ").append(this.additionalSoundChance);
            builder.append("\nADDITIONAL sounds [\n");
            builder.append(this.additionalSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (this.moodSounds.size() > 0) {
            builder.append("\nMOOD chance: ").append(this.additionalSoundChance);
            builder.append("\nMOOD sounds [\n");
            builder.append(this.moodSounds.stream().map(c -> "    " + c.toString()).collect(Collectors.joining("\n")));
            builder.append("\n]");
        }
        if (this.comments != null && this.comments.size() > 0) {
            builder.append("\ncomments:\n");
            builder.append(this.comments.stream().map(c -> "    " + c).collect(Collectors.joining("\n")));
            builder.append('\n');
        }
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public int compareTo(BiomeInfo o) {
        return this.getBiomeId().method_12833(o.getBiomeId());
    }
}

