/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config.biome;

import com.google.common.base.MoreObjects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;
import org.orecruncher.dsurround.lib.WeightTable;
import org.orecruncher.dsurround.lib.scripting.Script;
import org.orecruncher.dsurround.runtime.ConditionEvaluator;
import org.orecruncher.dsurround.sound.ISoundFactory;

@Environment(value=EnvType.CLIENT)
public class AcousticEntry
implements WeightTable.IItem<ISoundFactory> {
    private static final int DEFAULT_WEIGHT = 10;
    private final int weight;
    private final ISoundFactory acoustic;
    private final Script conditions;

    public AcousticEntry(ISoundFactory acoustic, @Nullable Script condition) {
        this(acoustic, condition, 10);
    }

    public AcousticEntry(ISoundFactory acoustic, @Nullable Script condition, int weight) {
        this.acoustic = acoustic;
        this.weight = weight;
        this.conditions = condition != null ? condition : Script.TRUE;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public ISoundFactory getItem() {
        return this.getAcoustic();
    }

    public ISoundFactory getAcoustic() {
        return this.acoustic;
    }

    public Script getConditions() {
        return this.conditions;
    }

    public boolean matches() {
        return ConditionEvaluator.INSTANCE.check(this.conditions);
    }

    protected Script getConditionsForLogging() {
        return this.getConditions();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.getWeight()).addValue((Object)this.getAcoustic().toString()).addValue((Object)this.getConditionsForLogging()).toString();
    }
}

