/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.data.SoundMetadataConfig;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;
import org.orecruncher.dsurround.sound.SoundMetadata;

@Environment(value=EnvType.CLIENT)
public final class SoundLibrary {
    private static final String FILE_NAME = "sounds.json";
    private static final UnboundedMapCodec<String, SoundMetadataConfig> CODEC = Codec.unboundedMap((Codec)Codec.STRING, SoundMetadataConfig.CODEC);
    private static final IModLog LOGGER = Client.LOGGER.createChild(SoundLibrary.class);
    private static final class_2960 MISSING_RESOURCE = new class_2960("dsurround", "missing_sound");
    public static final class_3414 MISSING = new class_3414(MISSING_RESOURCE);
    private static final Object2ObjectOpenHashMap<class_2960, class_3414> myRegistry = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<class_2960, SoundMetadata> soundMetadata = new Object2ObjectOpenHashMap();

    public static void load() {
        myRegistry.clear();
        soundMetadata.clear();
        class_2378.field_11156.forEach(se -> myRegistry.put((Object)se.method_14833(), se));
        Collection<IResourceAccessor> soundFiles = ResourceUtils.findSounds(FILE_NAME);
        for (IResourceAccessor file : soundFiles) {
            SoundLibrary.registerSoundFile(file);
        }
        LOGGER.info("Number of SoundEvents cached: %d", myRegistry.size());
    }

    private static void registerSoundFile(IResourceAccessor soundFile) {
        Map result = (Map)soundFile.as(CODEC);
        if (result != null && result.size() > 0) {
            class_2960 resource = soundFile.location();
            LOGGER.info("Processing %s", resource);
            result.forEach((key, value) -> {
                class_2960 loc = new class_2960(resource.method_12836(), key);
                if (!myRegistry.containsKey((Object)loc)) {
                    myRegistry.put((Object)loc, (Object)new class_3414(loc));
                }
                if (!value.isDefault()) {
                    SoundMetadata data = new SoundMetadata((SoundMetadataConfig)value);
                    soundMetadata.put((Object)loc, (Object)data);
                }
            });
        } else {
            LOGGER.debug("Skipping %s - unable to parse sound file or there are no sounds declared", soundFile.location());
        }
    }

    public static class_3414 getSound(String sound) {
        return SoundLibrary.getSound(new class_2960(sound));
    }

    public static class_3414 getSound(class_2960 sound) {
        Objects.requireNonNull(sound);
        class_3414 se = (class_3414)myRegistry.get((Object)sound);
        if (se == MISSING) {
            LOGGER.warn("Unable to locate sound '%s'", sound.toString());
        }
        return se;
    }

    public static Collection<class_3414> getRegisteredSoundEvents() {
        return myRegistry.values();
    }

    public static SoundMetadata getSoundMetadata(class_2960 sound) {
        return (SoundMetadata)soundMetadata.get((Object)Objects.requireNonNull(sound));
    }

    public static class_2960 resolveIdentifier(String defaultDomain, String name) {
        Preconditions.checkNotNull((Object)defaultDomain);
        Preconditions.checkNotNull((Object)name);
        class_2960 res = name.charAt(0) == '@' ? new class_2960("minecraft", name.substring(1)) : (!name.contains(":") ? new class_2960(defaultDomain, name) : new class_2960(name));
        return res;
    }

    static {
        myRegistry.defaultReturnValue((Object)MISSING);
        soundMetadata.defaultReturnValue((Object)new SoundMetadata());
    }
}

