/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.IndividualSoundConfigEntry;
import org.orecruncher.dsurround.lib.CodecExtensions;
import org.orecruncher.dsurround.lib.random.XorShiftRandom;

@Environment(value=EnvType.CLIENT)
public class SoundConfiguration {
    public static final Codec<List<IndividualSoundConfigEntry>> CODEC = Codec.list(IndividualSoundConfigEntry.CODEC);
    private static final Path SOUND_CONFIG_PATH = Client.CONFIG_PATH.resolve("soundconfig.json");
    protected final transient Map<class_2960, IndividualSoundConfigEntry> individualSoundConfiguration = new HashMap<class_2960, IndividualSoundConfigEntry>();
    protected final transient List<class_2960> startupSounds = new ArrayList<class_2960>();
    protected List<IndividualSoundConfigEntry> soundConfiguration = new ArrayList<IndividualSoundConfigEntry>();

    protected SoundConfiguration() {
        this.addSoundConfig("minecraft:entity.sheep.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.chicken.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.cow.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.pig.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.llama.ambient", 100, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.spawn", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.wither.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.ender_dragon.death", 10, false, true, false);
        this.addSoundConfig("minecraft:entity.experience_orb.pickup", 100, false, false, true);
        this.addSoundConfig("minecraft:entity.chicken.egg", 100, false, false, true);
        this.addSoundConfig("minecraft:ambient.underwater.exit", 100, false, false, true);
    }

    protected SoundConfiguration(List<IndividualSoundConfigEntry> list) {
        this.soundConfiguration = list;
    }

    public static SoundConfiguration getConfig() {
        SoundConfiguration config = null;
        try {
            if (Files.exists(SOUND_CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(SOUND_CONFIG_PATH);
                Optional<List<IndividualSoundConfigEntry>> result = CodecExtensions.deserialize(content, CODEC);
                if (result.isPresent()) {
                    config = new SoundConfiguration(result.get());
                } else {
                    Client.LOGGER.warn("Unable to obtain content of soundconfig!", new Object[0]);
                }
            }
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to handle configuration", new Object[0]);
        }
        if (config == null) {
            config = new SoundConfiguration();
        }
        config.validatePostLoad();
        config.save();
        return config;
    }

    private void addSoundConfig(String id, int volumeScale, boolean block, boolean cull, boolean startup) {
        IndividualSoundConfigEntry entry = new IndividualSoundConfigEntry(new class_2960(id), volumeScale, block, cull, startup);
        this.soundConfiguration.add(entry);
    }

    public boolean isBlocked(class_2960 id) {
        IndividualSoundConfigEntry entry = this.individualSoundConfiguration.get(id);
        return entry != null && entry.block;
    }

    public boolean isCulled(class_2960 id) {
        IndividualSoundConfigEntry entry = this.individualSoundConfiguration.get(id);
        return entry != null && entry.cull;
    }

    public Optional<class_3414> getRandomStartupSound() {
        if (this.startupSounds.size() == 0) {
            return Optional.empty();
        }
        int idx = 0;
        if (this.startupSounds.size() > 1) {
            idx = XorShiftRandom.current().nextInt(this.startupSounds.size());
        }
        return Optional.of(new class_3414(this.startupSounds.get(idx)));
    }

    public Collection<IndividualSoundConfigEntry> getIndividualSoundConfigs() {
        return this.soundConfiguration;
    }

    public void saveIndividualSoundConfigs(Collection<IndividualSoundConfigEntry> configs) {
        this.soundConfiguration = configs.stream().filter(IndividualSoundConfigEntry::isNotDefault).collect(Collectors.toList());
        this.save();
        this.validatePostLoad();
    }

    private void validatePostLoad() {
        this.individualSoundConfiguration.clear();
        this.soundConfiguration.forEach(entry -> {
            if (entry.isNotDefault()) {
                this.individualSoundConfiguration.put(entry.soundEventId, (IndividualSoundConfigEntry)entry);
                if (entry.startup) {
                    this.startupSounds.add(entry.soundEventId);
                }
            }
        });
    }

    private void save() {
        try {
            Optional result = CODEC.encode(this.soundConfiguration, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).result();
            if (result.isPresent()) {
                JsonArray content = class_3518.method_15252((JsonElement)((JsonElement)result.get()), (String)"soundconfig");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String output = gson.toJson((JsonElement)content);
                Files.writeString(SOUND_CONFIG_PATH, (CharSequence)output, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to save sound configuration!", new Object[0]);
        }
    }
}

