/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import org.orecruncher.dsurround.lib.FrameworkUtils;

class MyGsonConfigSerializer<T extends ConfigData>
implements ConfigSerializer<T> {
    private final Config definition;
    private final Class<T> configClass;
    private final Gson gson;

    public MyGsonConfigSerializer(Config definition, Class<T> configClass, Gson gson) {
        this.definition = definition;
        this.configClass = configClass;
        this.gson = gson;
    }

    public MyGsonConfigSerializer(Config definition, Class<T> configClass) {
        this(definition, configClass, new GsonBuilder().setPrettyPrinting().create());
    }

    private Path getConfigPath() {
        return FrameworkUtils.getConfigPath("dsurround").resolve(this.definition.name() + ".json");
    }

    public void serialize(T config) throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            this.gson.toJson(config, (Appendable)writer);
            writer.close();
        }
        catch (IOException var4) {
            throw new ConfigSerializer.SerializationException((Throwable)var4);
        }
    }

    public T deserialize() throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                BufferedReader reader = Files.newBufferedReader(configPath);
                ConfigData ret = (ConfigData)this.gson.fromJson((Reader)reader, this.configClass);
                reader.close();
                return (T)ret;
            }
            catch (JsonParseException | IOException var4) {
                throw new ConfigSerializer.SerializationException(var4);
            }
        }
        return this.createDefault();
    }

    public T createDefault() {
        try {
            Constructor<T> constructor = this.configClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)((ConfigData)constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException var2) {
            throw new RuntimeException(var2);
        }
    }
}

