/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.orecruncher.dsurround.lib.IMatcher;
import org.orecruncher.dsurround.lib.MatchOnClass;

@Environment(value=EnvType.CLIENT)
public abstract class EntityTypeMatcher
implements IMatcher<class_1297> {
    public static final Codec<IMatcher<class_1297>> CODEC = Codec.STRING.comapFlatMap(EntityTypeMatcher::manifestEntityType, Object::toString).stable();

    private static DataResult<IMatcher<class_1297>> manifestEntityType(String entityTypeId) {
        try {
            if (entityTypeId.contains(":")) {
                Optional type = class_1299.method_5898((String)entityTypeId);
                return type.map(entityType -> DataResult.success((Object)new MatchOnEntityType((class_1299<?>)entityType))).orElseGet(() -> DataResult.error((String)String.format("Unknown entity type id %s", entityTypeId)));
            }
            MatchOnClass matcher = MatchOnClass.parse(entityTypeId);
            if (matcher != null) {
                return DataResult.success(matcher);
            }
            return DataResult.error((String)String.format("Unknown entity class(s) %s", entityTypeId));
        }
        catch (Throwable t) {
            return DataResult.error((String)t.getMessage());
        }
    }

    @Override
    public abstract boolean match(class_1297 var1);

    private static class MatchOnEntityType
    extends EntityTypeMatcher {
        private final class_1299<?> type;

        public MatchOnEntityType(class_1299<?> type) {
            this.type = type;
        }

        @Override
        public boolean match(class_1297 entity) {
            return this.type == entity.method_5864();
        }
    }
}

