/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_3542;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.effects.entity.producers.BowUseEffectProducer;
import org.orecruncher.dsurround.effects.entity.producers.BreathEffectProducer;

@Environment(value=EnvType.CLIENT)
public enum EntityEffectType implements class_3542
{
    UNKNOWN("unknown", entity -> ImmutableList.of(), () -> false),
    BOW_PULL("bow_pull", entity -> new BowUseEffectProducer().produce((class_1309)entity), () -> Client.Config.entityEffects.enableBowPull),
    FROST_BREATH("frost_breath", entity -> new BreathEffectProducer().produce((class_1309)entity), () -> Client.Config.entityEffects.enableBreathEffect);

    private static final Map<String, EntityEffectType> BY_NAME;
    public static final Codec<EntityEffectType> CODEC;
    private final String name;
    private final Function<class_1309, Collection<IEntityEffect>> factory;
    private final Supplier<Boolean> enabled;

    private EntityEffectType(String name, Function<class_1309, Collection<IEntityEffect>> factory, Supplier<Boolean> enabled) {
        this.name = name;
        this.factory = factory;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Collection<IEntityEffect> produce(class_1309 entity) {
        if (this.isEnabled()) {
            return this.factory.apply(entity);
        }
        return ImmutableList.of();
    }

    public String method_15434() {
        return this.name;
    }

    public static EntityEffectType byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        BY_NAME = Arrays.stream(EntityEffectType.values()).collect(Collectors.toMap(EntityEffectType::getName, category -> category));
        CODEC = class_3542.method_28140(EntityEffectType::values, EntityEffectType::byName);
    }
}

