/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.EntityEffectType;
import org.orecruncher.dsurround.config.data.EntityEffectConfigRule;
import org.orecruncher.dsurround.effects.IEntityEffect;
import org.orecruncher.dsurround.effects.entity.EntityEffectInfo;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;
import org.orecruncher.dsurround.xface.ILivingEntityExtended;

@Environment(value=EnvType.CLIENT)
public class EntityEffectLibrary {
    private static final String FILE_NAME = "effects.json";
    private static final Codec<List<EntityEffectConfigRule>> CODEC = Codec.list(EntityEffectConfigRule.CODEC);
    private static final IModLog LOGGER = Client.LOGGER.createChild(EntityEffectLibrary.class);
    private static final Reference2ObjectMap<class_1299<?>, Set<EntityEffectType>> entityEffects = new Reference2ObjectOpenHashMap();
    private static Collection<EntityEffectConfigRule> entityConfigRules;
    private static EntityEffectInfo DEFAULT;
    private static int version;

    public static void load() {
        entityEffects.clear();
        Collection<IResourceAccessor> accessors = ResourceUtils.findConfigs(Client.DATA_PATH.toFile(), FILE_NAME);
        entityConfigRules = new ObjectArray<EntityEffectConfigRule>();
        IResourceAccessor.process(accessors, accessor -> {
            List<EntityEffectConfigRule> cfg = accessor.as(CODEC);
            if (cfg != null) {
                entityConfigRules.addAll(cfg);
            }
        });
        DEFAULT = new EntityEffectInfo(++version, null, (Collection)ImmutableList.of()){

            @Override
            public boolean isDefault() {
                return true;
            }

            @Override
            public void activate() {
            }

            @Override
            public void deactivate() {
            }

            @Override
            public void tick() {
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isVisibleTo(class_1657 player) {
                return false;
            }

            @Override
            public boolean isWithinDistance(class_1309 entity, int distance) {
                throw new RuntimeException("Should not be invoked on DEFAULT EntityEffectInfo");
            }
        };
        LOGGER.info("%d entity config rules loaded; version is now %d", entityConfigRules.size(), version);
    }

    public static boolean doesEntityEffectInfoExist(class_1309 entity) {
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        return accessor.getEffectInfo() != null;
    }

    public static void clearEntityEffectInfo(class_1309 entity) {
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        accessor.setEffectInfo(null);
    }

    public static EntityEffectInfo getEntityEffectInfo(class_1309 entity) {
        Set<EntityEffectType> types;
        ILivingEntityExtended accessor = (ILivingEntityExtended)entity;
        EntityEffectInfo info = accessor.getEffectInfo();
        if (info != null && info.getVersion() == version) {
            return info;
        }
        if (info != null) {
            info.deactivate();
            info = null;
        }
        if ((types = (Set<EntityEffectType>)entityEffects.get((Object)entity.method_5864())) == null) {
            types = EntityEffectLibrary.gatherEffectsFromConfigRules(entity);
            entityEffects.put((Object)entity.method_5864(), types);
        }
        ReferenceOpenHashSet effects = new ReferenceOpenHashSet();
        for (EntityEffectType type : types) {
            Collection<IEntityEffect> effectsToApply = type.produce(entity);
            effects.addAll(effectsToApply);
        }
        info = effects.size() > 0 ? new EntityEffectInfo(version, entity, (Collection<IEntityEffect>)effects) : DEFAULT;
        accessor.setEffectInfo(info);
        info.activate();
        return info;
    }

    private static Set<EntityEffectType> gatherEffectsFromConfigRules(class_1309 entity) {
        ReferenceOpenHashSet effectTypes = new ReferenceOpenHashSet();
        for (EntityEffectConfigRule rule : entityConfigRules) {
            if (!rule.match(entity)) continue;
            effectTypes.addAll(rule.effects);
        }
        return effectTypes;
    }
}

