/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.data.DimensionConfig;
import org.orecruncher.dsurround.config.dimension.DimensionInfo;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;

@Environment(value=EnvType.CLIENT)
public final class DimensionLibrary {
    private static final String FILE_NAME = "dimensions.json";
    private static final Codec<List<DimensionConfig>> CODEC = Codec.list(DimensionConfig.CODEC);
    private static final ObjectArray<DimensionConfig> cache = new ObjectArray();
    private static final Map<class_5321<class_1937>, DimensionInfo> configs = new HashMap<class_5321<class_1937>, DimensionInfo>();

    public static void load() {
        configs.clear();
        cache.clear();
        Collection<IResourceAccessor> accessors = ResourceUtils.findConfigs(Client.DATA_PATH.toFile(), FILE_NAME);
        IResourceAccessor.process(accessors, accessor -> {
            List<DimensionConfig> cfg = accessor.as(CODEC);
            if (cfg != null) {
                DimensionLibrary.initFromConfig(cfg);
            }
        });
    }

    private static void initFromConfig(List<DimensionConfig> cfg) {
        cfg.forEach(DimensionLibrary::register);
    }

    private static DimensionConfig getData(DimensionConfig entry) {
        Optional<DimensionConfig> result = cache.stream().filter(e -> e.equals(entry)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        cache.add(entry);
        return entry;
    }

    private static void register(DimensionConfig entry) {
        if (entry.dimensionId != null) {
            DimensionConfig data = DimensionLibrary.getData(entry);
            if (data == entry) {
                return;
            }
            if (entry.cloudHeight.isPresent()) {
                data.cloudHeight = entry.cloudHeight;
            }
            if (entry.seaLevel.isPresent()) {
                data.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight.isPresent()) {
                data.skyHeight = entry.skyHeight;
            }
            if (entry.alwaysOutside.isPresent()) {
                data.alwaysOutside = entry.alwaysOutside;
            }
            if (entry.playBiomeSounds.isPresent()) {
                data.playBiomeSounds = entry.playBiomeSounds;
            }
        }
    }

    public static DimensionInfo getData(class_1937 world) {
        class_5321 key = world.method_27983();
        DimensionInfo dimInfo = configs.get(key);
        if (dimInfo == null) {
            DimensionConfig config = null;
            class_2960 location = key.method_29177();
            for (DimensionConfig e : cache) {
                if (!e.dimensionId.equals((Object)location)) continue;
                config = e;
                break;
            }
            dimInfo = new DimensionInfo(world, config);
            configs.put((class_5321<class_1937>)key, dimInfo);
        }
        return dimInfo;
    }

    public static Stream<String> dump() {
        return cache.stream().map(Object::toString).sorted();
    }
}

