/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.lib.config.ConfigurationData;

@Environment(value=EnvType.CLIENT)
public class Configuration
extends ConfigurationData {
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for modifying logging behavior")
    public final Logging logging = new Logging();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for modifying Minecraft's Sound System behavior")
    public final SoundSystem soundSystem = new SoundSystem();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for enhanced sound processing")
    public final EnhancedSounds enhancedSounds = new EnhancedSounds();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for thunder storms")
    public final ThunderStorms thunderStorms = new ThunderStorms();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for block effects")
    public final BlockEffects blockEffects = new BlockEffects();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for entity effects")
    public final EntityEffects entityEffects = new EntityEffects();
    @ConfigurationData.Property
    @ConfigurationData.Comment(value="Configuration options for tweaking particle behavior")
    public final ParticleTweaks particleTweaks = new ParticleTweaks();

    public Configuration() {
        super("dsurround.config", Client.CONFIG_PATH.resolve("dsurround.json"));
    }

    public static Configuration getConfig() {
        try {
            return ConfigurationData.getConfig(Configuration.class);
        }
        catch (Throwable t) {
            Client.LOGGER.error(t, "Unable to get config", new Object[0]);
            return null;
        }
    }

    @Override
    public void postLoad() {
        Client.LOGGER.setDebug(this.logging.enableDebugLogging);
        Client.LOGGER.setTraceMask(this.logging.traceMask);
    }

    public static class Logging {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables/disables debug logging of the mod")
        public boolean enableDebugLogging = false;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Bitmask for toggling various debug traces")
        public int traceMask = 0;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable chat window notification of newer updates available")
        public boolean enableModUpdateChatMessage = true;
    }

    public static class SoundSystem {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=8, max=16)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="The number of sound channels to reserve for streaming sounds (music, biome sounds, records, etc.)")
        public int streamingChannels = 12;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=0, max=200)
        @ConfigurationData.Slider
        @ConfigurationData.Comment(value="Ticks between culled sound events (0 to disable culling)")
        public int cullInterval = 20;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables/disables cancellation of sound that a player will not hear")
        public boolean enableSoundPruning = true;
    }

    public static class EnhancedSounds {
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable enhanced sound processing (reverb, occlusion, etc)")
        public boolean enableEnhancedSounds = true;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=0, max=8)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.DefaultValue
        @ConfigurationData.Comment(value="Number of background threads to use for enhanced sound processing (0 means use internal default)")
        public int backgroundThreadWorkers = 0;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable HRTF sound processing if OpenAL feature is available")
        public boolean enableHRTF = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable on the fly conversion of stereo sounds to mono as needed")
        public boolean enableMonoConversion = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable sound occlusion processing (sound muffling behind blocks)")
        public boolean enableOcclusionProcessing = false;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.RestartRequired
        @ConfigurationData.DefaultValue
        @ConfigurationData.Comment(value="The number of rays to project around a sound location to calculate reverb effect")
        public int reverbRays = 32;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=2, max=8)
        @ConfigurationData.RestartRequired
        @ConfigurationData.DefaultValue
        @ConfigurationData.Comment(value="The number of reflections the ray calculation will perform before ending a ray calculation")
        public int reverbBounces = 4;
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=64, max=512)
        @ConfigurationData.RestartRequired
        @ConfigurationData.DefaultValue
        @ConfigurationData.Comment(value="Total distance a reverb ray will traverse before ending calculation")
        public int reverbRayTraceDistance = 256;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.DefaultValue
        @ConfigurationData.Hidden
        @ConfigurationData.Comment(value="Sets the output frequency for sound play.  Adjust only if you know what you are doing.")
        public int outputFrequency = 0;
    }

    public static class ThunderStorms {
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enables replacement of thunder sounds with Dynamic Surroundings' version")
        public boolean replaceThunderSounds = true;
    }

    public static class BlockEffects {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Distance that will be scanned when generating block effects")
        public int blockEffectRange = 24;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable steam column effect when liquids are adjacent to hot sources, like lava and magma")
        public boolean steamColumnEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable flame jets produced over lava, etc.")
        public boolean flameJetEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable bubble columns generated underwater")
        public boolean bubbleColumnEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable waterfall effect from flowing water")
        public boolean waterfallsEnabled = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable sounds from waterfalls")
        public boolean enableWaterfallSounds = true;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable particles from waterfalls")
        public boolean enableWaterfallParticles = true;
    }

    public static class EntityEffects {
        @ConfigurationData.Property
        @ConfigurationData.IntegerRange(min=16, max=64)
        @ConfigurationData.Slider
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="The maximum range at which entity special effects are applied")
        public int entityEffectRange = 24;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable bow pull sound effect")
        public boolean enableBowPull = true;
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable breath effect in cold biomes and underwater")
        public boolean enableBreathEffect = true;
    }

    public static class ParticleTweaks {
        @ConfigurationData.Property
        @ConfigurationData.RestartRequired
        @ConfigurationData.Comment(value="Enable/disable suppressing player potion particles in first person")
        public boolean suppressPlayerParticles = false;
        @ConfigurationData.Property
        @ConfigurationData.Comment(value="Enable/disable showing of projectile particle trails")
        public boolean showProjectileTrails = false;
    }

    public static class Flags {
        public static final int AUDIO_PLAYER = 1;
        public static final int BASIC_SOUND_PLAY = 2;
    }
}

