/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_5321;
import net.minecraft.class_5414;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.block.BlockInfo;
import org.orecruncher.dsurround.config.data.BlockConfigRule;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;
import org.orecruncher.dsurround.xface.IBlockStateExtended;

@Environment(value=EnvType.CLIENT)
public class BlockLibrary {
    private static final String FILE_NAME = "blocks.json";
    private static final Codec<List<BlockConfigRule>> CODEC = Codec.list(BlockConfigRule.CODEC);
    private static final IModLog LOGGER = Client.LOGGER.createChild(BlockLibrary.class);
    private static final int INDEFINITE = -1;
    private static final BlockInfo DEFAULT = new BlockInfo(-1){

        @Override
        public boolean isDefault() {
            return true;
        }
    };
    private static final Collection<BlockConfigRule> blockConfigs = new ObjectArray<BlockConfigRule>();
    private static int version = 0;

    public static void load() {
        blockConfigs.clear();
        Collection<IResourceAccessor> accessors = ResourceUtils.findConfigs(Client.DATA_PATH.toFile(), FILE_NAME);
        IResourceAccessor.process(accessors, accessor -> {
            List<BlockConfigRule> cfg = accessor.as(CODEC);
            if (cfg != null) {
                blockConfigs.addAll(cfg);
            }
        });
        LOGGER.info("%d block configs loaded; version is now %d", blockConfigs.size(), ++version);
    }

    public static BlockInfo getBlockInfo(class_2680 state) {
        BlockInfo info = ((IBlockStateExtended)state).getBlockInfo();
        if (info != null && (info.getVersion() == version || info == DEFAULT)) {
            return info;
        }
        info = new BlockInfo(version, state);
        for (BlockConfigRule cfg : blockConfigs) {
            if (!cfg.match(state)) continue;
            info.update(cfg);
        }
        if (info.isDefault()) {
            info = DEFAULT;
        } else {
            info.trim();
        }
        ((IBlockStateExtended)state).setBlockInfo(info);
        return info;
    }

    public static Stream<String> dumpBlockStates() {
        return GameUtils.getRegistryManager().method_30530(class_2378.field_25105).method_10220().flatMap(block -> block.method_9595().method_11662().stream()).map(class_2688::toString).sorted();
    }

    public static Stream<String> dumpBlockConfigRules() {
        return blockConfigs.stream().map(BlockLibrary::formatBlockConfigRuleOutput).sorted();
    }

    public static Stream<String> dumpBlocks() {
        Set blockRegistry = GameUtils.getRegistryManager().method_30530(class_2378.field_25105).method_29722();
        return blockRegistry.stream().map(kvp -> BlockLibrary.formatBlockOutput(((class_5321)kvp.getKey()).method_29177(), (class_2248)kvp.getValue())).sorted();
    }

    public static Stream<String> dumpBlocksByTag() {
        class_5414 tagGroup = GameUtils.getTagGroup(class_2378.field_25105);
        if (tagGroup != null) {
            return tagGroup.method_30204().entrySet().stream().filter(kvp -> ((class_3494)kvp.getValue()).method_15138().size() > 0).map(BlockLibrary::formatBlockTagOutput).sorted();
        }
        return Stream.empty();
    }

    private static String formatBlockConfigRuleOutput(BlockConfigRule rule) {
        return "";
    }

    private static String formatBlockTagOutput(Map.Entry<class_2960, class_3494<class_2248>> kvp) {
        StringBuilder builder = new StringBuilder();
        builder.append("Tag: ").append(kvp.getKey());
        for (class_2248 e : kvp.getValue().method_15138()) {
            builder.append("\n    ").append(e.toString());
        }
        builder.append("\n");
        return builder.toString();
    }

    private static String formatBlockOutput(class_2960 id, class_2248 block) {
        String tags = GameUtils.getWorld().method_8514().method_33164(class_2378.field_25105).method_30206((Object)block).stream().map(class_2960::toString).sorted().collect(Collectors.joining(","));
        StringBuilder builder = new StringBuilder();
        builder.append(id.toString());
        builder.append("\nTags: ").append(tags);
        builder.append("\nstates [\n");
        for (class_2680 blockState : block.method_9595().method_11662()) {
            builder.append(blockState.toString()).append("\n");
            BlockInfo info = BlockLibrary.getBlockInfo(blockState);
            builder.append(info);
        }
        builder.append("]\n");
        return builder.toString();
    }
}

