/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3542;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.effects.IBlockEffectProducer;
import org.orecruncher.dsurround.effects.blocks.producers.FlameJetProducer;
import org.orecruncher.dsurround.effects.blocks.producers.SteamColumnProducer;
import org.orecruncher.dsurround.effects.blocks.producers.UnderwaterBubbleProducer;
import org.orecruncher.dsurround.effects.blocks.producers.WaterSplashProducer;
import org.orecruncher.dsurround.lib.scripting.Script;

@Environment(value=EnvType.CLIENT)
public enum BlockEffectType implements class_3542
{
    UNKNOWN("unknown", (chance, condition) -> null, () -> false),
    STEAM_COLUMN("steam_column", SteamColumnProducer::new, () -> Client.Config.blockEffects.steamColumnEnabled),
    FLAME_JET("fire_jet", FlameJetProducer::new, () -> Client.Config.blockEffects.flameJetEnabled),
    BUBBLE_COLUMN("bubble_column", UnderwaterBubbleProducer::new, () -> Client.Config.blockEffects.bubbleColumnEnabled),
    WATERFALL("waterfall", WaterSplashProducer::new, () -> Client.Config.blockEffects.waterfallsEnabled);

    private static final Map<String, BlockEffectType> BY_NAME;
    public static final Codec<BlockEffectType> CODEC;
    private final String name;
    private final BiFunction<Script, Script, IBlockEffectProducer> producer;
    private final Supplier<Boolean> enabled;

    private BlockEffectType(String name, BiFunction<Script, Script, IBlockEffectProducer> producerFactory, Supplier<Boolean> enabled) {
        this.name = name;
        this.producer = producerFactory;
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public String method_15434() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public Optional<IBlockEffectProducer> getInstance(Script chance, Script conditions) {
        if (this.isEnabled()) {
            return Optional.ofNullable(this.producer.apply(chance, conditions));
        }
        return Optional.empty();
    }

    public static BlockEffectType byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        BY_NAME = Arrays.stream(BlockEffectType.values()).collect(Collectors.toMap(BlockEffectType::getName, category -> category));
        CODEC = class_3542.method_28140(BlockEffectType::values, BlockEffectType::byName);
    }
}

