/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.minecraft.class_1074;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.config.InternalBiomes;
import org.orecruncher.dsurround.config.biome.BiomeInfo;
import org.orecruncher.dsurround.config.biome.biometraits.BiomeTraits;
import org.orecruncher.dsurround.config.data.BiomeConfigRule;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.Guard;
import org.orecruncher.dsurround.lib.biome.BiomeUtils;
import org.orecruncher.dsurround.lib.collections.ObjectArray;
import org.orecruncher.dsurround.lib.logging.IModLog;
import org.orecruncher.dsurround.lib.resources.IResourceAccessor;
import org.orecruncher.dsurround.lib.resources.ResourceUtils;
import org.orecruncher.dsurround.runtime.BiomeConditionEvaluator;
import org.orecruncher.dsurround.xface.IBiomeExtended;

@Environment(value=EnvType.CLIENT)
public final class BiomeLibrary {
    private static final String FILE_NAME = "biomes.json";
    private static final Codec<List<BiomeConfigRule>> CODEC = Codec.list(BiomeConfigRule.CODEC);
    private static final IModLog LOGGER = Client.LOGGER.createChild(BiomeLibrary.class);
    private static final Map<InternalBiomes, BiomeInfo> internalBiomes = new EnumMap<InternalBiomes, BiomeInfo>(InternalBiomes.class);
    private static Collection<BiomeConfigRule> biomeConfigs;
    private static int version;

    public static void load() {
        internalBiomes.clear();
        ObjectArray<BiomeConfigRule> configs = new ObjectArray<BiomeConfigRule>(64);
        Collection<IResourceAccessor> accessors = ResourceUtils.findConfigs(Client.DATA_PATH.toFile(), FILE_NAME);
        IResourceAccessor.process(accessors, accessor -> {
            List<BiomeConfigRule> cfg = accessor.as(CODEC);
            if (cfg != null) {
                configs.addAll((Collection<BiomeConfigRule>)cfg);
            }
        });
        biomeConfigs = configs;
        ++version;
        for (InternalBiomes b : InternalBiomes.values()) {
            BiomeLibrary.initializeInternalBiome(b);
        }
        LOGGER.info("%d biome configs loaded; version is now %d", biomeConfigs.size(), version);
    }

    private static void initializeInternalBiome(InternalBiomes biome) {
        String match = "@" + biome.getName();
        BiomeInfo info = new BiomeInfo(version, biome.getId(), biome.getName(), biome.getTraits());
        for (BiomeConfigRule c : biomeConfigs) {
            if (!c.biomeSelector.asString().equalsIgnoreCase(match)) continue;
            info.update(c);
        }
        internalBiomes.put(biome, info);
    }

    private static class_2378<class_1959> getActiveRegistry() {
        return GameUtils.getRegistryManager().method_30530(class_2378.field_25114);
    }

    public static class_1959 getBiome(class_2960 biomeId) {
        return (class_1959)BiomeLibrary.getActiveRegistry().method_10223(biomeId);
    }

    public static BiomeInfo getBiomeInfo(class_1959 biome) {
        String name;
        class_2960 id;
        BiomeInfo info = ((IBiomeExtended)biome).getInfo();
        if (info != null && info.getVersion() == version) {
            return info;
        }
        if (info != null) {
            id = info.getBiomeId();
            name = info.getBiomeName();
        } else {
            id = BiomeLibrary.getBiomeId(biome);
            name = BiomeLibrary.getBiomeName(id);
        }
        BiomeTraits traits = BiomeTraits.createFrom(id, biome);
        BiomeInfo result = new BiomeInfo(version, id, name, traits);
        ((IBiomeExtended)biome).setInfo(result);
        Guard.execute(() -> BiomeLibrary.applyRuleConfigs(biome, result));
        return result;
    }

    public static BiomeInfo getBiomeInfo(InternalBiomes biome) {
        return internalBiomes.get((Object)biome);
    }

    private static void applyRuleConfigs(class_1959 biome, BiomeInfo info) {
        for (BiomeConfigRule c : biomeConfigs) {
            if (c.biomeSelector.asString().startsWith("@")) continue;
            try {
                boolean applies = BiomeConditionEvaluator.INSTANCE.check(biome, c.biomeSelector);
                if (!applies) continue;
                try {
                    info.update(c);
                }
                catch (Throwable t) {
                    LOGGER.warn("Unable to process biome sound configuration [%s]", c.toString());
                }
            }
            catch (Throwable t) {
                LOGGER.error(t, "Unexpected error processing biome %s", info.getBiomeId());
            }
        }
        info.trim();
    }

    static class_2960 getBiomeId(class_1959 biome) {
        class_2378<class_1959> biomeRegistry = BiomeLibrary.getActiveRegistry();
        class_2960 id = biomeRegistry.method_10221((Object)biome);
        if (id == null) {
            id = BiomeUtils.DEFAULT_ID;
        }
        return id;
    }

    public static String getBiomeName(class_2960 id) {
        String fmt = String.format("biome.%s.%s", id.method_12836(), id.method_12832());
        return class_1074.method_4662((String)fmt, (Object[])new Object[0]);
    }

    public static Stream<String> dumpBiomes() {
        return BiomeLibrary.getActiveRegistry().method_10220().map(BiomeLibrary::getBiomeInfo).map(BiomeInfo::toString).sorted();
    }

    static {
        version = 0;
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> LOGGER.info("Biome registry reload detected", new Object[0]));
    }
}

