/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.io.PrintStream;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import org.orecruncher.dsurround.Client;
import org.orecruncher.dsurround.commands.Commands;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.config.DimensionLibrary;

@Environment(value=EnvType.CLIENT)
class DumpCommand {
    DumpCommand() {
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"dsdump").then(ClientCommandManager.literal((String)"biomes").executes(cmd -> DumpCommand.dumpBiomes((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"sounds").executes(cmd -> DumpCommand.dumpSounds((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"dimensions").executes(cmd -> DumpCommand.dumpDimensions((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"blocks").executes(cmd -> DumpCommand.dumpBlocks((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"blocksbytag").executes(cmd -> DumpCommand.dumpBlocksByTag((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"blockconfigrules").executes(cmd -> DumpCommand.dumpBlockConfigRules((FabricClientCommandSource)cmd.getSource())))).then(ClientCommandManager.literal((String)"blockstates").executes(cmd -> DumpCommand.dumpBlockState((FabricClientCommandSource)cmd.getSource()))));
    }

    private static int dumpBiomes(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.biomes", BiomeLibrary::dumpBiomes);
    }

    private static int dumpSounds(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.sounds", DumpCommand::tbd);
    }

    private static int dumpDimensions(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.dimensions", DimensionLibrary::dump);
    }

    private static int dumpBlockConfigRules(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.blockconfigrules", BlockLibrary::dumpBlockConfigRules);
    }

    private static int dumpBlockState(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.blockstates", BlockLibrary::dumpBlockStates);
    }

    private static int dumpBlocks(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.blocks", BlockLibrary::dumpBlocks);
    }

    private static int dumpBlocksByTag(FabricClientCommandSource src) {
        return DumpCommand.handle(src, "dump.blocksbytag", BlockLibrary::dumpBlocksByTag);
    }

    private static int handle(FabricClientCommandSource source, String cmdString, Supplier<Stream<String>> supplier) {
        String operation = cmdString.substring(5);
        String fileName = operation + ".txt";
        File target = Client.DUMP_PATH.resolve(fileName).toFile();
        try {
            try (PrintStream out = new PrintStream(target);){
                Stream<String> stream = supplier.get();
                stream.forEach(out::println);
                out.flush();
            }
            catch (Throwable t) {
                Client.LOGGER.error(t, "Error writing dump file '%s'", target.toString());
            }
            Commands.sendSuccess(source, "dump", operation, target.toString());
        }
        catch (Throwable t) {
            Commands.sendFailure(source, cmdString, operation);
        }
        return 0;
    }

    private static Stream<String> tbd() {
        ImmutableList result = ImmutableList.of((Object)"Not hooked up");
        return result.stream();
    }
}

