/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.orecruncher.dsurround.commands.Commands;
import org.orecruncher.dsurround.config.BiomeLibrary;
import org.orecruncher.dsurround.config.BlockLibrary;
import org.orecruncher.dsurround.config.Configuration;
import org.orecruncher.dsurround.config.DimensionLibrary;
import org.orecruncher.dsurround.config.EntityEffectLibrary;
import org.orecruncher.dsurround.config.SoundConfiguration;
import org.orecruncher.dsurround.config.SoundLibrary;
import org.orecruncher.dsurround.gui.keyboard.KeyBindings;
import org.orecruncher.dsurround.lib.FrameworkUtils;
import org.orecruncher.dsurround.lib.GameUtils;
import org.orecruncher.dsurround.lib.TickCounter;
import org.orecruncher.dsurround.lib.logging.ModLog;
import org.orecruncher.dsurround.lib.version.VersionChecker;
import org.orecruncher.dsurround.processing.Handlers;
import org.orecruncher.dsurround.runtime.diagnostics.BlockViewer;
import org.orecruncher.dsurround.runtime.diagnostics.ClientProfiler;
import org.orecruncher.dsurround.runtime.diagnostics.RuntimeDiagnostics;
import org.orecruncher.dsurround.runtime.diagnostics.SoundEngineDiagnostics;

@Environment(value=EnvType.CLIENT)
public class Client
implements ClientModInitializer {
    public static final String ModId = "dsurround";
    public static final ModLog LOGGER = new ModLog("dsurround");
    public static final Path CONFIG_PATH = FrameworkUtils.getConfigPath("dsurround");
    public static final Path DATA_PATH = Path.of(CONFIG_PATH.toString(), "configs");
    public static final Path DUMP_PATH = Path.of(CONFIG_PATH.toString(), "dumps");
    public static final String Branding = FrameworkUtils.getModBranding("dsurround");
    public static final Configuration Config = Configuration.getConfig();
    public static final SoundConfiguration SoundConfig = SoundConfiguration.getConfig();
    private FrameworkUtils.ModCustomData modInfo;
    private CompletableFuture<Optional<VersionChecker.VersionResult>> versionInfo;

    public void onInitializeClient() {
        LOGGER.info("Initializing...", new Object[0]);
        Optional<FrameworkUtils.ModCustomData> info = FrameworkUtils.getModCustomData(ModId, ModId);
        info.ifPresent(value -> {
            this.modInfo = value;
        });
        Client.createPath(CONFIG_PATH);
        Client.createPath(DATA_PATH);
        Client.createPath(DUMP_PATH);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onComplete);
        ClientPlayConnectionEvents.JOIN.register(this::onConnect);
        TickCounter.register();
        KeyBindings.register();
        Commands.register();
        RuntimeDiagnostics.register();
        ClientProfiler.register();
        SoundEngineDiagnostics.register();
        BlockViewer.register();
        LOGGER.info("Initialization complete", new Object[0]);
    }

    private static void createPath(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (Throwable t) {
            LOGGER.error(t, "Unable to create data path %s", path.toString());
        }
    }

    public void refreshConfigs() {
        SoundLibrary.load();
        BiomeLibrary.load();
        DimensionLibrary.load();
        BlockLibrary.load();
        EntityEffectLibrary.load();
    }

    public void onComplete(class_310 client) {
        this.refreshConfigs();
        Handlers.initialize();
        this.versionInfo = CompletableFuture.supplyAsync(this::getVersionText);
    }

    private Optional<VersionChecker.VersionResult> getVersionText() {
        if (this.modInfo == null) {
            return Optional.empty();
        }
        Optional<ModContainer> modContainer = FrameworkUtils.getModContainer(ModId);
        if (modContainer.isEmpty()) {
            return Optional.empty();
        }
        ModMetadata metadata = modContainer.get().getMetadata();
        String displayName = metadata.getName();
        Version modVersion = metadata.getVersion();
        Version minecraftVersion = FrameworkUtils.getModVersion("minecraft");
        URL updateURL = null;
        try {
            updateURL = new URL(this.modInfo.getString("updateURL"));
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to parse update URL", new Object[0]);
        }
        if (updateURL == null) {
            return Optional.empty();
        }
        return VersionChecker.getUpdateText(displayName, minecraftVersion, modVersion, updateURL);
    }

    private void onConnect(class_634 clientPlayNetworkHandler, PacketSender packetSender, class_310 minecraftClient) {
        try {
            Optional<VersionChecker.VersionResult> versionQueryResult;
            if (this.versionInfo != null && (versionQueryResult = this.versionInfo.get()).isPresent()) {
                VersionChecker.VersionResult result = versionQueryResult.get();
                LOGGER.info("Update to %s v%s is available", result.displayName, result.version);
                if (Client.Config.logging.enableModUpdateChatMessage) {
                    class_1657 player = GameUtils.getPlayer();
                    player.method_7353(versionQueryResult.get().getChatText(), false);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error(t, "Unable to process version information", new Object[0]);
        }
    }
}

