/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.paste;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ProcessPopup;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.LocalizedIOException;
import com.tom.cpl.util.ThrowingConsumer;
import com.tom.cpl.util.ThrowingFunction;
import com.tom.cpl.util.ThrowingRunnable;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.paste.PasteClient;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.function.Consumer;

public class PastePopup
extends PopupPanel {
    private static PasteClient client = new PasteClient(MinecraftClientAccess.get().getMojangAPI(), "https://paste.tom5454.com", "https://cf-paste.tom5454.com");
    private final Frame frm;
    private Panel panel;
    private ScrollPanel scp;
    private Label statusLbl;

    public PastePopup(Frame frame) {
        super(frame.getGui());
        this.frm = frame;
        this.setBounds(new Box(0, 0, 400, 300));
        this.scp = new ScrollPanel(this.gui);
        this.scp.setBounds(new Box(5, 5, 390, 270));
        this.addElement(this.scp);
        this.panel = new Panel(this.gui);
        this.panel.setBackgroundColor(-8947849);
        this.scp.setDisplay(this.panel);
        this.panel.setBounds(new Box(0, 0, this.scp.getBounds().w, 16));
        this.statusLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
        this.statusLbl.setBounds(new Box(100, 280, 200, 10));
        this.addElement(this.statusLbl);
    }

    public void open() {
        this.frm.openPopup(this);
        this.refreshGui();
    }

    private static void handleException(Frame frm, Runnable retry, Runnable close, Throwable e) {
        IGui gui = frm.getGui();
        if (e instanceof LocalizedIOException) {
            frm.openPopup(new ConfirmPopup(frm, gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("label.cpm.paste.error", ((LocalizedIOException)e).getLoc().toString(gui)), retry, () -> {
                if (!client.isConnected()) {
                    close.run();
                }
            }, gui.i18nFormat("button.cpm.retry", new Object[0])));
        } else {
            frm.openPopup(new ConfirmPopup(frm, gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.paste.unknownNetworkError", e.toString()), retry, () -> {
                if (!client.isConnected()) {
                    close.run();
                }
            }, gui.i18nFormat("button.cpm.retry", new Object[0])));
        }
    }

    private void refreshGui() {
        this.runRequest(client::listFiles, (T entries) -> {
            this.panel.getElements().clear();
            this.panel.setBounds(new Box(0, 0, this.bounds.w - 10, entries.size() * 32));
            entries.sort(Comparator.comparing(p -> p.time));
            for (int i = 0; i < entries.size(); ++i) {
                PasteClient.Paste e = (PasteClient.Paste)entries.get(i);
                this.panel.addElement(new PastePanel(e, i * 32, this.scp.getBounds().w, i));
            }
            int mx = client.getMaxSize() / 1024;
            String maxSize = mx > 1024 ? mx / 1024 + " MB" : mx + " kB";
            this.statusLbl.setText(this.gui.i18nFormat("label.cpm.paste.status", entries.size(), client.getMaxPastes(), maxSize));
        }, "listing");
    }

    public static <T> void runRequest(Frame frm, ThrowingFunction<PasteClient, T, Exception> task, Consumer<T> finish, Runnable close, String name) {
        if (!PastePopup.client.isConnected()) {
            PastePopup.runRequest0(frm, client -> {
                client.connect();
                return null;
            }, v -> PastePopup.runRequest0(frm, task, finish, close, name), close, "connecting.message");
        } else {
            PastePopup.runRequest0(frm, task, finish, close, name);
        }
    }

    public static void runRequest(Frame frm, ThrowingConsumer<PasteClient, Exception> task, Runnable finish, Runnable close, String name) {
        PastePopup.runRequest(frm, (PasteClient client) -> {
            task.accept((PasteClient)client);
            return null;
        }, (T v) -> finish.run(), close, name);
    }

    private static <T> void runRequest0(Frame frm, ThrowingFunction<PasteClient, T, Exception> task, Consumer<T> finish, Runnable close, String name) {
        IGui gui = frm.getGui();
        new ProcessPopup<Object>(frm, gui.i18nFormat("label.cpm.paste.connecting.title", new Object[0]), gui.i18nFormat("label.cpm.paste." + name, new Object[0]), () -> task.apply(client), finish, e -> PastePopup.handleException(frm, () -> PastePopup.runRequest(frm, task, finish, close, name), close, e)).start();
    }

    private <T> void runRequest(Callable<T> task, Consumer<T> finish, String name) {
        PastePopup.runRequest(this.frm, (PasteClient _c) -> task.call(), finish, this::close, name);
    }

    private void runRequest(ThrowingRunnable<Exception> task, Runnable finish, String name) {
        PastePopup.runRequest(this.frm, (PasteClient _c) -> task.run(), finish, this::close, name);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.edit.pastes", new Object[0]);
    }

    private class PastePanel
    extends Panel {
        private Tooltip tooltip;

        public PastePanel(PasteClient.Paste entry, int y, int w, int i) {
            super(PastePopup.this.getGui());
            this.addElement(new Label(this.gui, entry.name).setBounds(new Box(5, 4, 200, 10)));
            this.tooltip = new Tooltip(PastePopup.this.frm, this.gui.i18nFormat("tooltip.cpm.paste.paste", String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", entry.time), entry.id));
            Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.delete", new Object[0]), new ConfirmPopup(PastePopup.this.frm, this.gui.i18nFormat("label.cpm.confirm", new Object[0]), this.gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> PastePopup.this.runRequest(() -> client.deleteFile(entry.id), PastePopup.this::refreshGui, "deleting"), null));
            btn.setBounds(new Box(w - 55, 5, 45, 20));
            this.addElement(btn);
            this.setBounds(new Box(0, y, w, 31));
            if (i % 2 == 1) {
                this.setBackgroundColor(this.gui.getColors().menu_bar_background);
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (event.isHovered(this.bounds)) {
                this.tooltip.set();
            }
        }
    }
}

