/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.paste;

import com.google.gson.JsonParseException;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.LocalizedIOException;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.io.HTTPIO;
import com.tom.cpm.shared.util.Log;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.IOException;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class PasteClient {
    public static final String URL = "https://paste.tom5454.com";
    public static final String URL_CF = "https://cf-paste.tom5454.com";
    private MojangAPI mojang;
    private String url;
    private String fallback;
    private String session;
    private long loginTime = -1L;
    private int maxSize = -1;
    private int maxPastes = -1;

    public PasteClient(MojangAPI mojang, String url, String fallback) {
        this.mojang = mojang;
        this.url = url;
        this.fallback = fallback;
    }

    public void connect() throws IOException {
        byte[] mojangKey;
        String response;
        URL url = new URL(this.url + "/api/connect?name=" + this.mojang.getName());
        HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, false);
        try {
            response = HTTPIO.getResponse(httpCon, url);
            Log.info("[Paste API]: Connected to paste site");
        }
        catch (ConnectException | SocketTimeoutException e) {
            Log.info("[Paste API]: Paste site timeout, trying fallback");
            url = new URL(this.fallback + "/api/connect?name=" + this.mojang.getName());
            httpCon = HTTPIO.createUrlConnection(url, false);
            response = HTTPIO.getResponse(httpCon, url);
            this.url = this.fallback;
            Log.info("[Paste API]: Connection success using fallback");
        }
        Map<String, Object> r = this.parseResponse(response);
        this.session = (String)r.get("id");
        byte[] mojKey = Base64.getDecoder().decode((String)r.get("key"));
        try {
            mojangKey = PasteClient.digestData("tom5454-paste".getBytes(), this.session.getBytes(), mojKey);
        }
        catch (Exception e) {
            throw new LocalizedIOException("Unknown error", new FormatText("error.paste.unknown", new Object[0]), e);
        }
        try {
            this.mojang.joinServer(new BigInteger(mojangKey).toString(16));
        }
        catch (LocalizedIOException e) {
            throw new LocalizedIOException(e.getMessage(), new FormatText("error.paste.authFail", e.getLoc()), e.getCause());
        }
        url = new URL(this.url + "/api/session");
        httpCon = this.createUrlConnection(url);
        response = HTTPIO.getResponse(httpCon, url);
        this.parseResponse(response);
        this.loginTime = System.currentTimeMillis();
        Log.info("[Paste API]: Connection success");
    }

    public List<Paste> listFiles() throws IOException {
        URL url = new URL(this.url + "/api/list");
        HttpURLConnection httpCon = this.createUrlConnection(url);
        String response = HTTPIO.getResponse(httpCon, url);
        Map<String, Object> r = this.parseResponse(response);
        List files = (List)r.get("files");
        ArrayList<Paste> ret = new ArrayList<Paste>();
        files.forEach(m -> {
            String id = (String)m.get("id");
            String name = (String)m.get("name");
            long time = Long.parseLong((String)m.get("time"));
            ret.add(new Paste(id, name, time));
        });
        this.maxSize = ((Number)r.get("maxSize")).intValue();
        this.maxPastes = ((Number)r.get("maxFiles")).intValue();
        return ret;
    }

    public String uploadFile(String name, byte[] content) throws IOException {
        URL url = new URL(this.url + "/api/upload");
        HttpURLConnection httpCon = this.createUrlConnection(url);
        httpCon.setRequestProperty("File-Name", name);
        httpCon.setRequestProperty("Content-Length", Integer.toString(content.length));
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("POST");
        httpCon.getOutputStream().write(content);
        String response = HTTPIO.getResponse(httpCon, url);
        Map<String, Object> r = this.parseResponse(response);
        return (String)r.get("id");
    }

    public void updateFile(String id, byte[] content) throws IOException {
        URL url = new URL(this.url + "/api/update?file=" + id);
        HttpURLConnection httpCon = this.createUrlConnection(url);
        httpCon.setRequestProperty("Content-Length", Integer.toString(content.length));
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("POST");
        httpCon.getOutputStream().write(content);
        this.parseResponse(HTTPIO.getResponse(httpCon, url));
    }

    public void deleteFile(String id) throws IOException {
        URL url = new URL(this.url + "/api/delete?file=" + id);
        HttpURLConnection httpCon = this.createUrlConnection(url);
        this.parseResponse(HTTPIO.getResponse(httpCon, url));
    }

    private HttpURLConnection createUrlConnection(URL url) throws IOException {
        HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, false);
        httpCon.setRequestProperty("Session", this.session);
        return httpCon;
    }

    private Map<String, Object> parseResponse(String response) throws IOException {
        try {
            Map r = (Map)MinecraftObjectHolder.gson.fromJson(response, Object.class);
            if (r.containsKey("error")) {
                if ("error.paste.invalidSession".equals(r.get("errorMessage"))) {
                    this.loginTime = -1L;
                }
                throw new LocalizedIOException(String.valueOf(r.get("error")), new FormatText(String.valueOf(r.get("errorMessage")), new Object[0]));
            }
            return r;
        }
        catch (JsonParseException | ClassCastException e) {
            throw new LocalizedIOException("Result parse error", new FormatText("error.paste.parseError", new Object[0]), e);
        }
    }

    private static byte[] digestData(byte[] ... p_244731_0_) throws Exception {
        MessageDigest messagedigest = MessageDigest.getInstance("SHA-1");
        for (byte[] abyte : p_244731_0_) {
            messagedigest.update(abyte);
        }
        return messagedigest.digest();
    }

    public boolean isConnected() {
        return this.loginTime != -1L && System.currentTimeMillis() - this.loginTime < 900000L;
    }

    public int getMaxPastes() {
        return this.maxPastes;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public static class Paste {
        public final String id;
        public final String name;
        public final long time;

        public Paste(String id, String name, long time) {
            this.id = id;
            this.name = name;
            this.time = time;
        }
    }
}

