/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.KeybindText;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.NBTS2C;
import java.lang.invoke.CallSite;
import java.util.Map;

public class RecommendSafetyS2C
extends NBTS2C {
    public RecommendSafetyS2C(NBTTagCompound data) {
        super(data);
    }

    public RecommendSafetyS2C() {
    }

    @Override
    public void handle(NetHandler<?, ?, ?> handler, NetH from) {
        String server = MinecraftClientAccess.get().getConnectedServer();
        ModConfigFile cc = ModConfig.getCommonConfig();
        ConfigEntry ss = cc.getEntry("serverSettings");
        if (server != null && ss.hasEntry(server) && ss.getEntry(server).getBoolean("ignoreSafetyRec", false)) {
            return;
        }
        BuiltInSafetyProfiles netProfile = BuiltInSafetyProfiles.get(this.tag.getString("profile"));
        ConfigEntry ce = null;
        if (netProfile == BuiltInSafetyProfiles.CUSTOM) {
            try {
                Map map = (Map)MinecraftObjectHolder.gson.fromJson(this.tag.getString("data"), Object.class);
                ce = new ConfigEntry(map, () -> {});
            }
            catch (Exception e) {
                return;
            }
        }
        handler.getRecommendedSettingChanges().clear();
        PlayerSpecificConfigKey[] e = ConfigKeys.SAFETY_KEYS;
        int n = e.length;
        for (int i = 0; i < n; ++i) {
            Object sv;
            PlayerSpecificConfigKey k;
            Object rv = ce != null ? k.getValue(ce, PlayerSpecificConfigKey.KeyGroup.GLOBAL) : k.getValue(netProfile);
            if (rv.equals(sv = (k = e[i]).getValueFor(server, null, cc))) continue;
            handler.getRecommendedSettingChanges().add(new ConfigChangeRequest<PlayerSpecificConfigKey, Object>(k, sv, rv));
        }
        if (!handler.getRecommendedSettingChanges().isEmpty()) {
            ConfigEntry e2;
            ConfigEntry gs = cc.getEntry("globalSettings");
            String[] spf = gs.getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase()).split(":", 2);
            BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
            if (server != null && ss.hasEntry(server) && (e2 = ss.getEntry(server)).hasEntry("safetyProfile")) {
                spf = e2.getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase()).split(":", 2);
                profile = SocialConfig.getProfile(spf);
            }
            Object old = profile == BuiltInSafetyProfiles.CUSTOM ? "custom:" + spf[1] : profile.name().toLowerCase();
            if (netProfile == BuiltInSafetyProfiles.CUSTOM) {
                handler.getRecommendedSettingChanges().add(new ConfigChangeRequest<String, CallSite>("safetyProfile", (CallSite)old, (CallSite)((Object)("custom:import-" + server))));
            } else {
                handler.getRecommendedSettingChanges().add(new ConfigChangeRequest<String, String>("safetyProfile", (String)old, netProfile.name().toLowerCase()));
            }
            handler.displayText(new FormatText("chat.cpm.serverSafetySettings", new KeybindText("key.cpm.gestureMenu", "gestureMenu")));
        }
    }
}

