/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.function.TriFunction;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.util.Pair;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerData;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.network.IPacket;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.ReceiveEventS2C;
import com.tom.cpm.shared.network.packet.RecommendSafetyS2C;
import com.tom.cpm.shared.network.packet.SetSkinC2S;
import com.tom.cpm.shared.network.packet.SetSkinS2C;
import com.tom.cpm.shared.util.ScalingOptions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;

public class NetworkUtil {
    public static final String FORCED_TAG = "forced";
    public static final String DATA_TAG = "data";
    public static final String PROFILE_TAG = "profile";
    public static final String PROFILE_DATA = "data";
    public static final String SERVER_CAPS = "caps";
    public static final String EVENT_LIST = "eventList";
    public static final String KICK_TIME = "kickTime";
    public static final String SCALING = "scaling";
    public static final String GESTURE = "gesture";
    public static final FormatText FORCED_CHAT_MSG = new FormatText("chat.cpm.skinForced", new Object[0]);

    public static <P> void sendPlayerData(NetHandler<?, P, ?> handler, P target, P to) {
        PlayerData dt = handler.getSNetH(target).cpm$getEncodedModelData();
        if (dt == null) {
            return;
        }
        handler.sendPacketTo(handler.getSNetH(to), NetworkUtil.writeSkinData(handler, dt, target));
        if (dt.gestureData.length > 0) {
            NBTTagCompound evt = new NBTTagCompound();
            evt.setByteArray(GESTURE, dt.gestureData);
            handler.sendPacketTo(handler.getSNetH(to), new ReceiveEventS2C(handler.getPlayerId(target), evt));
        }
    }

    public static <P> IPacket writeSkinData(NetHandler<?, P, ?> handler, PlayerData dt, P target) {
        NBTTagCompound data = new NBTTagCompound();
        if (dt.data != null) {
            data.setBoolean(FORCED_TAG, dt.forced);
            data.setByteArray("data", dt.data);
        }
        return new SetSkinS2C(handler.getPlayerId(target), data);
    }

    public static void sendSafetySettings(NetHandler<?, ?, ?> handler, NetH.ServerNetH net) {
        BuiltInSafetyProfiles profile = BuiltInSafetyProfiles.get(ModConfig.getWorldConfig().getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase()));
        if (profile != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.setString(PROFILE_TAG, profile.name().toLowerCase());
            if (profile == BuiltInSafetyProfiles.CUSTOM) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                ConfigEntry main = ModConfig.getWorldConfig().getEntry("safetySettings");
                ConfigEntry ce = new ConfigEntry(map, () -> {});
                for (PlayerSpecificConfigKey key : ConfigKeys.SAFETY_KEYS) {
                    PlayerSpecificConfigKey.KeyGroup v = key.getValue(main, PlayerSpecificConfigKey.KeyGroup.GLOBAL);
                    NetworkUtil.sendSafetySettings$setValue(ce, key, (Object)v);
                }
                tag.setString("data", MinecraftObjectHolder.gson.toJson(map));
            }
            handler.sendPacketTo(net, new RecommendSafetyS2C(tag));
        }
    }

    private static <T> void sendSafetySettings$setValue(ConfigEntry ce, PlayerSpecificConfigKey<T> key, Object value) {
        key.setValue(ce, value);
    }

    public static Pair<Float, Float> getScalingLimits(ScalingOptions o, String id) {
        ConfigEntry g;
        ModConfigFile e = ModConfig.getWorldConfig();
        ConfigEntry pl = e.getEntry("player_scaling_settings");
        if (!NetworkUtil.getValue(pl, g = e.getEntry("scaling_settings"), id, o.name().toLowerCase(), "enabled", ConfigEntry::getBoolean, o.getDefualtEnabled()).booleanValue()) {
            return null;
        }
        float min = NetworkUtil.getValue(pl, g, id, o.name().toLowerCase(), "min", ConfigEntry::getFloat, Float.valueOf(o.getMin())).floatValue();
        float max = NetworkUtil.getValue(pl, g, id, o.name().toLowerCase(), "max", ConfigEntry::getFloat, Float.valueOf(o.getMax())).floatValue();
        return Pair.of(Float.valueOf(min), Float.valueOf(max));
    }

    private static <T> T getValue(ConfigEntry pl, ConfigEntry g, String id, String opt, String key, TriFunction<ConfigEntry, String, T, T> getter, T def) {
        if (pl.hasEntry(id) && (pl = pl.getEntry(id)).hasEntry(opt) && (pl = pl.getEntry(opt)).hasEntry(key)) {
            return getter.apply(pl, key, (ConfigEntry)def);
        }
        g = g.getEntry(opt);
        return getter.apply(g, key, (ConfigEntry)def);
    }

    public static void sendSkinDataToServer(NetHandler<?, ?, ?> handler) {
        String model = ModConfig.getCommonConfig().getString("selectedModel", null);
        if (model != null) {
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            try {
                ModelFile file = ModelFile.load(new File(modelsDir, model));
                NBTTagCompound data = new NBTTagCompound();
                data.setByteArray("data", file.getDataBlock());
                file.registerLocalCache(MinecraftClientAccess.get().getDefinitionLoader());
                handler.sendPacketToServer(new SetSkinC2S(data));
            }
            catch (IOException e) {
                handler.sendPacketToServer(new SetSkinC2S(new NBTTagCompound()));
            }
        } else {
            handler.sendPacketToServer(new SetSkinC2S(new NBTTagCompound()));
        }
    }
}

