/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model.render;

import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.shared.gui.panel.ViewportPanelBase3d;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelElement;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.model.builtin.VanillaPartRenderer;
import com.tom.cpm.shared.model.builtin.VanillaPlayerModel;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.PlayerModelLayer;
import java.util.function.Supplier;

public class GuiModelRenderManager
extends ModelRenderManager<VBuffers, ViewportPanelBase3d, VanillaPartRenderer, VanillaPlayerModel> {
    public static final String PLAYER = "player";

    public GuiModelRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<VBuffers, ViewportPanelBase3d, VanillaPartRenderer>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, VBuffers, ViewportPanelBase3d, VanillaPartRenderer> create(M model, String arg) {
                if (model instanceof VanillaPlayerModel) {
                    return new RedirectHolderPlayer(GuiModelRenderManager.this, (VanillaPlayerModel)model, arg);
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<VanillaPlayerModel, ViewportPanelBase3d, VanillaPartRenderer>(){

            @Override
            public ModelRenderManager.RedirectRenderer<VanillaPartRenderer> create(VanillaPlayerModel model, ModelRenderManager.RedirectHolder<VanillaPlayerModel, ?, ViewportPanelBase3d, VanillaPartRenderer> access, Supplier<VanillaPartRenderer> modelPart, VanillaModelPart part) {
                return new RedirectPartRenderer((RedirectHolderPlayer)access, modelPart, part);
            }
        });
        this.setVis(m -> m.visible, (m, v) -> {
            m.visible = v;
        });
        this.setModelPosGetters(m -> m.x, m -> m.y, m -> m.z);
        this.setModelRotGetters(m -> m.xRot, m -> m.yRot, m -> m.zRot);
        this.setModelSetters((m, x, y, z) -> {
            m.x = x;
            m.y = y;
            m.z = z;
        }, (m, x, y, z) -> {
            m.xRot = x;
            m.yRot = y;
            m.zRot = z;
        });
    }

    @Override
    public void unbindModel(VanillaPlayerModel model) {
        ModelRenderManager.RedirectHolder h = (ModelRenderManager.RedirectHolder)this.holders.remove(model);
        if (h != null) {
            h.swapOut();
        }
    }

    public static class RedirectPartRenderer
    extends VanillaPartRenderer
    implements ModelRenderManager.RedirectRenderer<VanillaPartRenderer> {
        protected final RedirectHolderPlayer holder;
        protected final VanillaModelPart part;
        protected final Supplier<VanillaPartRenderer> parentProvider;
        protected VanillaPartRenderer parent;
        private MatrixStack stack;
        private VertexBuffer buf;
        private VBuffers buffers;

        public RedirectPartRenderer(RedirectHolderPlayer holder, Supplier<VanillaPartRenderer> parent, VanillaModelPart part) {
            this.part = part;
            this.holder = holder;
            this.parentProvider = parent;
        }

        @Override
        public VanillaPartRenderer swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            this.holder.copyModel(this.parent, this);
            return this;
        }

        @Override
        public VanillaPartRenderer swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            VanillaPartRenderer p = this.parent;
            this.parent = null;
            return p;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, VanillaPartRenderer> getHolder() {
            return this.holder;
        }

        @Override
        public VanillaPartRenderer getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public void renderParent() {
            this.parent.render(this.stack, this.buf);
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public Vec4f getColor() {
            return new Vec4f(1.0f, 1.0f, 1.0f, 1.0f);
        }

        @Override
        public void render(MatrixStack stack, VertexBuffer buf) {
            this.stack = stack;
            this.buf = buf;
            this.buffers = ((VBuffers)this.holder.addDt).normal(buf).transform(stack);
            this.render();
            this.buffers = null;
            this.stack = null;
            this.buf = null;
        }

        @Override
        public void doRender0(RootModelElement elem, boolean doRender) {
            MatrixStack stack = new MatrixStack();
            stack.push();
            this.holder.transform(stack, this.holder.def.getScale());
            this.translateRotate(stack);
            VBuffers buf = this.getVBuffers();
            Vec4f color = this.getColor();
            this.render(elem, stack, buf, color.x, color.y, color.z, color.w, true, true);
            stack.pop();
        }

        @Override
        public void translateRotatePart(MatrixStack matrixStackIn) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                matrixStackIn.setLast(e);
            } else {
                super.translateRotatePart(matrixStackIn);
            }
        }

        public void renderParent(VertexBuffer buf) {
            this.parent.render(new MatrixStack(), buf);
        }
    }

    public static class RedirectHolderPlayer
    extends ModelRenderManager.RedirectHolder<VanillaPlayerModel, VBuffers, ViewportPanelBase3d, VanillaPartRenderer> {
        public RedirectHolderPlayer(ModelRenderManager<VBuffers, ViewportPanelBase3d, VanillaPartRenderer, VanillaPlayerModel> mngr, VanillaPlayerModel model, String arg) {
            super(mngr, model);
            if (arg.equals(GuiModelRenderManager.PLAYER)) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.head, v -> {
                    model.head = v;
                }, PlayerModelParts.HEAD));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.body, v -> {
                    model.body = v;
                }, PlayerModelParts.BODY));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.rightArm, v -> {
                    model.rightArm = v;
                }, PlayerModelParts.RIGHT_ARM));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.leftArm, v -> {
                    model.leftArm = v;
                }, PlayerModelParts.LEFT_ARM));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.rightLeg, v -> {
                    model.rightLeg = v;
                }, PlayerModelParts.RIGHT_LEG));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.leftLeg, v -> {
                    model.leftLeg = v;
                }, PlayerModelParts.LEFT_LEG));
            } else if (arg.equals(PlayerModelLayer.CAPE.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.cape, v -> {
                    model.cape = v;
                }, RootModelType.CAPE));
            } else if (arg.equals(PlayerModelLayer.ELYTRA.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.elytraRight, v -> {
                    model.elytraRight = v;
                }, RootModelType.ELYTRA_RIGHT));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.elytraLeft, v -> {
                    model.elytraLeft = v;
                }, RootModelType.ELYTRA_LEFT));
            } else if (arg.equals(PlayerModelLayer.HELMET.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorHelmet, v -> {
                    model.armorHelmet = v;
                }, RootModelType.ARMOR_HELMET));
            } else if (arg.equals(PlayerModelLayer.BODY.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorBody, v -> {
                    model.armorBody = v;
                }, RootModelType.ARMOR_BODY));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorRightArm, v -> {
                    model.armorRightArm = v;
                }, RootModelType.ARMOR_RIGHT_ARM));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorLeftArm, v -> {
                    model.armorLeftArm = v;
                }, RootModelType.ARMOR_LEFT_ARM));
            } else if (arg.equals(PlayerModelLayer.BOOTS.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorRightFoot, v -> {
                    model.armorRightFoot = v;
                }, RootModelType.ARMOR_RIGHT_FOOT));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorLeftFoot, v -> {
                    model.armorLeftFoot = v;
                }, RootModelType.ARMOR_LEFT_FOOT));
            } else if (arg.equals(PlayerModelLayer.LEGS.name())) {
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorLeggingsBody, v -> {
                    model.armorLeggingsBody = v;
                }, RootModelType.ARMOR_LEGGINGS_BODY));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorRightLeg, v -> {
                    model.armorRightLeg = v;
                }, RootModelType.ARMOR_RIGHT_LEG));
                this.register(new ModelRenderManager.Field<VanillaPartRenderer>(() -> model.armorLeftLeg, v -> {
                    model.armorLeftLeg = v;
                }, RootModelType.ARMOR_LEFT_LEG));
            } else {
                throw new RuntimeException("Undefined argument: " + arg);
            }
        }

        @Override
        protected void swapIn0() {
        }

        @Override
        protected void swapOut0() {
        }

        @Override
        protected void setupRenderSystem(ViewportPanelBase3d cbi, TextureSheetType tex) {
            cbi.putRenderTypes(this.renderTypes);
        }

        @Override
        protected void bindTexture(ViewportPanelBase3d cbi, TextureProvider skin) {
            skin.bind();
            cbi.load();
        }

        @Override
        protected void bindDefaultTexture(ViewportPanelBase3d cbi, TextureSheetType tex) {
            cbi.load(tex.name().toLowerCase());
        }

        @Override
        protected boolean isInGui() {
            return true;
        }
    }
}

