/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.BoundingBox;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.editor.util.PlayerSkinLayer;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.SkinType;

public enum PlayerPartValues implements PartValues
{
    HEAD(PlayerModelParts.HEAD, PlayerSkinLayer.HAT, 0.0f, 0.0f, 0.0f, -4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0, 0, 32, 0),
    BODY(PlayerModelParts.BODY, PlayerSkinLayer.JACKET, 0.0f, 0.0f, 0.0f, -4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, 16, 16, 16, 32),
    LEFT_ARM(PlayerModelParts.LEFT_ARM, PlayerSkinLayer.LEFT_SLEEVE, 5.0f, 2.0f, 0.0f, -1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, 32, 48, 48, 48, SkinType.DEFAULT),
    RIGHT_ARM(PlayerModelParts.RIGHT_ARM, PlayerSkinLayer.RIGHT_SLEEVE, -5.0f, 2.0f, 0.0f, -3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, 40, 16, 40, 32, SkinType.DEFAULT),
    LEFT_ARM_S(PlayerModelParts.LEFT_ARM, PlayerSkinLayer.LEFT_SLEEVE, 5.0f, 2.0f, 0.0f, -1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 32, 48, 48, 48, SkinType.SLIM),
    RIGHT_ARM_S(PlayerModelParts.RIGHT_ARM, PlayerSkinLayer.RIGHT_SLEEVE, -5.0f, 2.0f, 0.0f, -2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, 40, 16, 40, 32, SkinType.SLIM),
    LEFT_LEG(PlayerModelParts.LEFT_LEG, PlayerSkinLayer.LEFT_PANTS_LEG, 1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 16, 48, 0, 48),
    RIGHT_LEG(PlayerModelParts.RIGHT_LEG, PlayerSkinLayer.RIGHT_PANTS_LEG, -1.9f, 12.0f, 0.0f, -2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, 0, 16, 0, 32);

    public static final BoundingBox PLAYER_BOUNDING_BOX;
    public static final BoundingBox PLAYER_SNEAKING_BOUNDING_BOX;
    public static final BoundingBox PLAYER_SMALL_BOUNDING_BOX;
    public static final BoundingBox PLAYER_SKULL;
    public static final float PLAYER_EYE_HEIGHT = 1.62f;
    public static final float PLAYER_EYE_HEIGHT_SNEAKING = 1.27f;
    public static final float PLAYER_EYE_HEIGHT_SMALL = 0.4f;
    public static final PlayerPartValues[] VALUES;
    public final PlayerModelParts part;
    public final PlayerSkinLayer layer;
    public final float px;
    public final float py;
    public final float pz;
    public final float ox;
    public final float oy;
    public final float oz;
    public final float sx;
    public final float sy;
    public final float sz;
    public final int u;
    public final int v;
    public final int u2;
    public final int v2;
    public final SkinType skinType;

    private PlayerPartValues(PlayerModelParts part, PlayerSkinLayer layer, float px, float py, float pz, float ox, float oy, float oz, float sx, float sy, float sz, int u, int v, int u2, int v2) {
        this(part, layer, px, py, pz, ox, oy, oz, sx, sy, sz, u, v, u2, v2, SkinType.UNKNOWN);
    }

    private PlayerPartValues(PlayerModelParts part, PlayerSkinLayer layer, float px, float py, float pz, float ox, float oy, float oz, float sx, float sy, float sz, int u, int v, int u2, int v2, SkinType skinType) {
        this.part = part;
        this.layer = layer;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
        this.sx = sx;
        this.sy = sy;
        this.sz = sz;
        this.u = u;
        this.v = v;
        this.u2 = u2;
        this.v2 = v2;
        this.skinType = skinType;
    }

    public static PlayerPartValues getFor(PlayerModelParts part, SkinType skinType) {
        for (PlayerPartValues v : VALUES) {
            if (v.part != part || v.skinType != skinType && v.skinType != SkinType.UNKNOWN) continue;
            return v;
        }
        return null;
    }

    @Override
    public Vec3f getPos() {
        return new Vec3f(this.px, this.py, this.pz);
    }

    @Override
    public Vec3f getOffset() {
        return new Vec3f(this.ox, this.oy, this.oz);
    }

    @Override
    public Vec3f getSize() {
        return new Vec3f(this.sx, this.sy, this.sz);
    }

    @Override
    public Vec2i getUV() {
        return new Vec2i(this.u, this.v);
    }

    @Override
    public boolean isMirror() {
        return false;
    }

    @Override
    public float getMCScale() {
        return 0.0f;
    }

    public static float getEyeHeight(VanillaPose pose) {
        if (pose == null) {
            pose = VanillaPose.STANDING;
        }
        switch (pose) {
            case FLYING: 
            case SWIMMING: {
                return 0.4f;
            }
            case SNEAKING: {
                return 1.27f;
            }
            case SKULL_RENDER: {
                return -1.0f;
            }
        }
        return 1.62f;
    }

    public static BoundingBox getBounds(VanillaPose pose) {
        if (pose == null) {
            return PLAYER_BOUNDING_BOX;
        }
        switch (pose) {
            case FLYING: 
            case SWIMMING: {
                return PLAYER_SMALL_BOUNDING_BOX;
            }
            case SNEAKING: {
                return PLAYER_SNEAKING_BOUNDING_BOX;
            }
            case SKULL_RENDER: {
                return PLAYER_SKULL;
            }
        }
        return PLAYER_BOUNDING_BOX;
    }

    static {
        PLAYER_BOUNDING_BOX = new BoundingBox(-0.3f, 0.0f, -0.3f, 0.3f, 1.8f, 0.3f);
        PLAYER_SNEAKING_BOUNDING_BOX = new BoundingBox(-0.3f, 0.0f, -0.3f, 0.3f, 1.5f, 0.3f);
        PLAYER_SMALL_BOUNDING_BOX = new BoundingBox(-0.3f, 0.0f, -0.3f, 0.3f, 0.6f, 0.3f);
        PLAYER_SKULL = new BoundingBox(-0.25f, 0.0f, -0.25f, 0.25f, 0.5f, 0.25f).mul(0.9090909f);
        VALUES = PlayerPartValues.values();
    }
}

