/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RenderedCube;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cube {
    public Vec3f offset;
    public Vec3f rotation;
    public Vec3f pos;
    public Vec3f size;
    public Vec3f scale;
    public int parentId;
    public int id;
    public int rgb;
    public int u;
    public int v;
    public int texSize;
    public float mcScale;

    public static Cube loadDefinitionCube(IOHelper din) throws IOException {
        Cube c = new Cube();
        Cube.loadCubePos(c, din);
        byte tex = din.readByte();
        if (tex == 0) {
            int ch4;
            int ch3;
            int ch2 = din.read();
            if ((ch2 | (ch3 = din.read()) | (ch4 = din.read())) < 0) {
                throw new EOFException();
            }
            c.rgb = -16777216 + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        } else {
            c.texSize = tex;
            c.u = din.read();
            c.v = din.read();
        }
        return c;
    }

    public static Cube loadDefinitionCube(Map<String, Object> map) {
        Cube c = new Cube();
        c.offset = new Vec3f((Map)map.get("offset"), new Vec3f());
        c.pos = new Vec3f((Map)map.get("pos"), new Vec3f());
        c.rotation = new Vec3f((Map)map.get("rotation"), new Vec3f());
        c.size = new Vec3f((Map)map.get("size"), new Vec3f(1.0f, 1.0f, 1.0f));
        c.scale = new Vec3f((Map)map.get("scale"), new Vec3f(1.0f, 1.0f, 1.0f));
        c.u = ((Number)map.get("u")).intValue();
        c.v = ((Number)map.get("v")).intValue();
        c.rgb = Integer.parseUnsignedInt((String)map.get("color"), 16);
        c.texSize = ((Number)map.get("textureSize")).intValue();
        c.mcScale = ((Number)map.get("mcScale")).floatValue();
        c.parentId = ((Number)map.get("parent")).intValue();
        return c;
    }

    public static void saveDefinitionCube(IOHelper dout, Cube cube) throws IOException {
        dout.writeVec3ub(cube.size);
        dout.writeVec6b(cube.pos);
        dout.writeVec6b(cube.offset);
        Vec3f rot = new Vec3f(cube.rotation);
        if (rot.x < 0.0f || rot.x > 360.0f || rot.y < 0.0f || rot.y > 360.0f || rot.z < 0.0f || rot.z > 360.0f) {
            while (rot.x < 0.0f) {
                rot.x += 360.0f;
            }
            while (rot.x >= 360.0f) {
                rot.x -= 360.0f;
            }
            while (rot.y < 0.0f) {
                rot.y += 360.0f;
            }
            while (rot.y >= 360.0f) {
                rot.y -= 360.0f;
            }
            while (rot.z < 0.0f) {
                rot.z += 360.0f;
            }
            while (rot.z >= 360.0f) {
                rot.z -= 360.0f;
            }
        }
        dout.writeAngle(rot);
        dout.writeVarInt(cube.parentId);
        dout.writeByte(cube.texSize);
        if (cube.texSize == 0) {
            dout.write(cube.rgb >>> 16 & 0xFF);
            dout.write(cube.rgb >>> 8 & 0xFF);
            dout.write(cube.rgb >>> 0 & 0xFF);
        } else {
            dout.write(cube.u);
            dout.write(cube.v);
        }
    }

    public static void saveDefinitionCube(Map<String, Object> map, Cube cube) throws IOException {
        map.put("offset", cube.offset.toMap());
        map.put("pos", cube.pos.toMap());
        map.put("rotation", cube.rotation.toMap());
        map.put("size", cube.size.toMap());
        map.put("scale", cube.scale.toMap());
        map.put("u", cube.u);
        map.put("v", cube.v);
        map.put("color", Integer.toHexString(cube.rgb));
        map.put("mcScale", Float.valueOf(cube.mcScale));
        map.put("textureSize", cube.texSize);
        map.put("parent", cube.parentId);
    }

    public static Cube loadTemplateCube(IOHelper din, int[] colors) throws IOException {
        Cube c = new Cube();
        Cube.loadCubePos(c, din);
        c.rgb = colors[din.read()];
        return c;
    }

    private static void loadCubePos(Cube c, IOHelper din) throws IOException {
        c.size = din.readVec3ub();
        c.pos = din.readVec6b();
        c.offset = din.readVec6b();
        c.rotation = din.readAngle();
        c.scale = new Vec3f(1.0f, 1.0f, 1.0f);
        c.parentId = din.readVarInt();
    }

    public static List<RenderedCube> resolveCubes(List<Cube> cubes) {
        HashMap<Integer, RenderedCube> r = new HashMap<Integer, RenderedCube>();
        for (Cube cube : cubes) {
            r.put(cube.id, new RenderedCube(cube));
        }
        for (Cube c : cubes) {
            if (c.parentId < 10) continue;
            RenderedCube cube = (RenderedCube)r.get(c.id);
            RenderedCube parent = (RenderedCube)r.get(c.parentId);
            cube.setParent(parent);
            parent.addChild(cube);
        }
        return new ArrayList<RenderedCube>(r.values());
    }

    public static Cube newFakeCube() {
        Cube c = new Cube();
        c.offset = new Vec3f();
        c.size = new Vec3f();
        c.pos = new Vec3f();
        c.rotation = new Vec3f();
        c.parentId = PlayerModelParts.CUSTOM_PART.ordinal();
        return c;
    }
}

