/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.KeybindsPopup;
import com.tom.cpm.shared.gui.panel.ListPanel;
import com.tom.cpm.shared.gui.panel.SafetyHeaderPanel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SettingsPanel
extends Panel {
    private final Frame frm;
    private TabbedPanelManager tabs;
    private TabbedPanelManager safety;
    private HorizontalLayout topPanel;
    private HorizontalLayout safetyPanel;
    private ModConfigFile.ConfigEntryTemp ce;
    private Button buttonPosMode;
    private Runnable save;

    public SettingsPanel(Frame frm, SettingsPanel panel, int width, int height, Runnable save) {
        this(frm, null, width, height, panel == null ? ModConfig.getCommonConfig().createTemp() : panel.ce, save);
        this.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
    }

    public SettingsPanel(Frame frm, PopupPanel popup, int width, int height, Runnable save) {
        this(frm, popup, width, height, ModConfig.getCommonConfig().createTemp(), save);
    }

    private SettingsPanel(Frame frm, PopupPanel popup, int width, int height, ModConfigFile.ConfigEntryTemp ce, Runnable save) {
        super(frm.getGui());
        this.frm = frm;
        this.save = save;
        this.setBounds(new Box(0, 0, width, height));
        this.ce = ce;
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 50));
        this.addElement(this.tabs);
        Button saveBtn = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), this::saveConfig);
        this.addElement(saveBtn);
        saveBtn.setBounds(new Box(5, height - 25, 80, 20));
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        Panel general = new Panel(this.gui);
        this.addTabScroll("general", general, 5);
        FlowLayout layout = new FlowLayout(general, 4, 1);
        this.makeCheckbox(general, "showLoadingInfo", true);
        Button kbButton = new Button(this.gui, this.gui.i18nFormat("label.cpm.keybinds.title", new Object[0]), () -> frm.openPopup(new KeybindsPopup(frm, ce)));
        kbButton.setBounds(new Box(5, 0, 150, 20));
        general.addElement(kbButton);
        this.makeCheckbox(general, "wikiOfflineMode", false);
        this.makeCheckbox(general, "gestureAutoReset", true);
        MinecraftClientAccess.get().populatePlatformSettings("general", general);
        layout.reflow();
        Panel editor = new Panel(this.gui);
        this.addTabScroll("editor", editor, 5);
        FlowLayout editorLayout = new FlowLayout(editor, 5, 1);
        this.makeCheckbox(editor, "titleScreenButton", true);
        if (this.gui.getMaxScale() != -1) {
            Button guiScale = new Button(this.gui, this.gui.i18nFormat("button.cpm.config.scale", this.getScale()), null);
            guiScale.setAction(() -> {
                int scale = ce.getInt("editorScale", -1) + 1;
                if (scale >= this.gui.getMaxScale()) {
                    scale = this.gui.canScaleVanilla() ? -1 : 0;
                }
                ce.setInt("editorScale", scale);
                if (popup != null) {
                    try {
                        EditorGui.rescaleGui = false;
                        popup.close();
                        this.gui.setScale(scale);
                        guiScale.setText(this.gui.i18nFormat("button.cpm.config.scale", this.getScale()));
                        frm.openPopup(popup);
                    }
                    finally {
                        EditorGui.rescaleGui = true;
                    }
                }
            });
            guiScale.setBounds(new Box(5, 0, 250, 20));
            editor.addElement(guiScale);
        }
        this.makeCheckbox(editor, "advScalingSettings", false);
        this.buttonPosMode = new Button(this.gui, "", null);
        this.buttonPosMode.setAction(() -> {
            ce.setBoolean("editorPosMode", !ce.getBoolean("editorPosMode", false));
            this.updatePosModeBtn();
        });
        this.buttonPosMode.setBounds(new Box(5, 0, 250, 20));
        this.updatePosModeBtn();
        this.addAlphaSlider(editor, "editorGizmoAlpha", 255);
        this.addAlphaSlider(editor, "editorUVAreaAlpha", 204);
        this.addAlphaSlider(editor, "editorUVAreaAllAlpha", 85);
        this.makeCheckbox(editor, "editorGizmoScale", true);
        this.addScaleSlider(editor, "editorGizmoSize", 1.0f, 0.1f, 0.2f, 2.0f);
        this.addScaleSlider(editor, "editorGizmoLength", 1.0f, 0.1f, 0.2f, 2.0f);
        Slider autoSaveSlider = this.addScaleSlider(editor, "editorAutosaveTime", 300.0f, 15.0f, -1.0f, 900.0f);
        autoSaveSlider.setSteps(v -> {
            float val = v * 901.0f - 1.0f;
            int rv = Math.round(val / 15.0f) * 15;
            if (rv <= 0) {
                rv = -1;
            }
            return ((float)rv + 1.0f) / 901.0f;
        });
        MinecraftClientAccess.get().populatePlatformSettings("editor", editor);
        editorLayout.reflow();
        Panel safetyTabPanel = new Panel(this.gui);
        this.addTab("safety", safetyTabPanel, 0);
        Panel safetyPanel = new Panel(this.gui);
        safetyPanel.setBounds(new Box(0, 0, width, 20));
        safetyPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        safetyTabPanel.addElement(safetyPanel);
        this.safetyPanel = new HorizontalLayout(safetyPanel);
        this.safety = new TabbedPanelManager(this.gui);
        this.safety.setBounds(new Box(0, 20, width, height - 40));
        safetyTabPanel.addElement(this.safety);
        ConfigEntry spfs = ce.getEntry("safetyProfiles");
        SafetyHeaderPanel globalSafety = new SafetyHeaderPanel(frm, ce.getEntry("globalSettings"), width, this.gui.i18nFormat("label.cpm.globalSafetyS", new Object[0]), SettingsPanel.createMap("safetyBtn", spfs), PlayerSpecificConfigKey.KeyGroup.GLOBAL, ce);
        ScrollPanel scpG = new ScrollPanel(this.gui);
        scpG.setDisplay(globalSafety);
        this.addSafetyTab("global", scpG, 5);
        Panel serverList = new Panel(this.gui);
        this.addSafetyTab("server", serverList, 5);
        String server = MinecraftClientAccess.get().getConnectedServer();
        this.buildListPanel(serverList, ce.getEntry("serverSettings"), server != null ? new Srv(server) : null, (k, v) -> new Srv((String)k, v.getString("name", Util.hideIp(k))), k -> k.ip, e -> new Tooltip(frm, this.gui.isShiftDown() && this.gui.isAltDown() ? this.gui.i18nFormat("tooltip.cpm.serverInfo", e.ip) : this.gui.i18nFormat("tooltip.cpm.displServerInfo", new Object[0])), SettingsPanel.createMap("nameBoxInit", true, "safetyBtn", spfs, "server", true), e -> PlayerSpecificConfigKey.KeyGroup.GLOBAL, true);
        SafetyHeaderPanel friends = new SafetyHeaderPanel(frm, ce.getEntry("friendSettings"), width, this.gui.i18nFormat("label.cpm.friendSafetyS", new Object[0]), Collections.emptyMap(), PlayerSpecificConfigKey.KeyGroup.FRIEND, ce);
        ScrollPanel scpF = new ScrollPanel(this.gui);
        scpF.setDisplay(friends);
        this.addSafetyTab("friends", scpF, 5);
        Panel player = new Panel(this.gui);
        this.addSafetyTab("player", player, 5);
        this.buildListPanel(player, ce.getEntry("playerSettings"), null, (k, v) -> new Pl((String)k, v.getString("name", this.gui.i18nFormat("label.cpm.unknown", new Object[0]))), k -> k.uuid, e -> new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.playerInfo", e.name, e.uuid)), Collections.emptyMap(), Pl::getKeyGroup, false);
        String v2 = this.gui.i18nFormat("label.cpm.runtimeVersion", PlatformFeature.getVersion());
        this.addElement(new Label(this.gui, v2).setBounds(new Box(width - this.gui.textWidth(v2) - 3, height - 11, 0, 0)));
    }

    private void addAlphaSlider(Panel panel, String key, int def) {
        Panel p = new Panel(this.gui);
        p.setBounds(new Box(0, 0, 320, 20));
        panel.addElement(p);
        Slider alphaSlider = new Slider(this.gui, this.formatAlphaSlider(key, def));
        alphaSlider.setSteps(0.003921569f);
        alphaSlider.setBounds(new Box(5, 0, 250, 20));
        alphaSlider.setAction(() -> {
            this.ce.setFloat(key, alphaSlider.getValue());
            alphaSlider.setText(this.formatAlphaSlider(key, def));
        });
        alphaSlider.setValue(this.ce.getFloat(key, (float)def / 255.0f));
        alphaSlider.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.config." + key, new Object[0])));
        p.addElement(alphaSlider);
        Button btnR = new Button(this.gui, this.gui.i18nFormat("button.cpm.settings.reset", new Object[0]), () -> {
            this.ce.setFloat(key, (float)def / 255.0f);
            alphaSlider.setValue((float)def / 255.0f);
            alphaSlider.setText(this.formatAlphaSlider(key, def));
        });
        btnR.setBounds(new Box(260, 0, 60, 20));
        p.addElement(btnR);
    }

    private Slider addScaleSlider(Panel panel, String key, float def, float div, float min, float max) {
        Panel p = new Panel(this.gui);
        p.setBounds(new Box(0, 0, 320, 20));
        panel.addElement(p);
        Slider scaleSlider = new Slider(this.gui, this.formatScaleSlider(key, def));
        scaleSlider.setSteps(1.0f / ((max - min) / div));
        scaleSlider.setBounds(new Box(5, 0, 250, 20));
        scaleSlider.setAction(() -> {
            this.ce.setFloat(key, scaleSlider.getValue() * (max - min) + min);
            scaleSlider.setText(this.formatScaleSlider(key, def));
        });
        scaleSlider.setValue((this.ce.getFloat(key, def) - min) / (max - min));
        scaleSlider.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.config." + key, new Object[0])));
        p.addElement(scaleSlider);
        Button btnR = new Button(this.gui, this.gui.i18nFormat("button.cpm.settings.reset", new Object[0]), () -> {
            this.ce.setFloat(key, def);
            scaleSlider.setValue((def - min) / (max - min));
            scaleSlider.setText(this.formatScaleSlider(key, def));
        });
        btnR.setBounds(new Box(260, 0, 60, 20));
        p.addElement(btnR);
        return scaleSlider;
    }

    private String formatAlphaSlider(String key, int def) {
        float v = this.ce.getFloat(key, (float)def / 255.0f);
        return this.gui.i18nFormat("label.cpm.config." + key, (int)(v * 255.0f));
    }

    private String formatScaleSlider(String key, float def) {
        float v = this.ce.getFloat(key, def);
        return this.gui.i18nFormat("label.cpm.config." + key, String.format("%.1f", Float.valueOf(v)));
    }

    private void makeCheckbox(Panel panel, String key, boolean def) {
        Checkbox chxbx = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.config." + key, new Object[0]));
        chxbx.setSelected(this.ce.getBoolean(key, def));
        chxbx.setAction(() -> {
            boolean b = !this.ce.getBoolean(key, def);
            chxbx.setSelected(b);
            this.ce.setBoolean(key, b);
        });
        chxbx.setBounds(new Box(5, 0, 200, 20));
        chxbx.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.config." + key, new Object[0])));
        panel.addElement(chxbx);
    }

    private void saveConfig() {
        this.ce.saveConfig();
        MinecraftClientAccess.get().getDefinitionLoader().clearCache();
        this.save.run();
    }

    public void addTabScroll(String name, Panel panel, int topPadding) {
        ScrollPanel scp = new ScrollPanel(this.gui);
        scp.setBounds(new Box(0, 0, this.bounds.w, this.bounds.h - 50));
        panel.setBounds(new Box(0, 0, this.bounds.w, 0));
        scp.setDisplay(panel);
        Panel p = new Panel(this.gui);
        p.addElement(scp);
        this.addTab(name, p, topPadding);
    }

    public void addTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 50));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.settings." + name, new Object[0]), panel));
    }

    public void addSafetyTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 70));
        this.safetyPanel.add(this.safety.createTab(this.gui.i18nFormat("tab.cpm.settings.safety." + name, new Object[0]), panel));
    }

    private String getScale() {
        int scale = this.ce.getInt("editorScale", this.gui.canScaleVanilla() ? -1 : 0);
        return scale == -1 ? this.gui.i18nFormat("button.cpm.config.scale.vanilla", new Object[0]) : (scale == 0 ? this.gui.i18nFormat("button.cpm.config.scale.auto", new Object[0]) : Integer.toString(scale));
    }

    private void updatePosModeBtn() {
        String mode = this.ce.getBoolean("editorPosMode", false) ? "absolute" : "relative";
        this.buttonPosMode.setText(this.gui.i18nFormat("button.cpm.config.posMode", this.gui.i18nFormat("button.cpm.config.posMode." + mode, new Object[0])));
        this.buttonPosMode.setTooltip(new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.config.posMode." + mode, new Object[0])));
    }

    private <E> void buildListPanel(Panel panel, ConfigEntry ce, E current, BiFunction<String, ConfigEntry, E> func, Function<E, String> getKey, Function<E, Tooltip> tooltip, Map<String, Object> fieldsIn, Function<E, PlayerSpecificConfigKey.KeyGroup> getKg, boolean enableAdd) {
        int w = panel.getBounds().w;
        int lw = w / 4;
        int spw = w - lw - 10;
        ScrollPanel scpS = new ScrollPanel(this.gui);
        scpS.setBounds(new Box(lw + 10, 5, spw, panel.getBounds().h - 10));
        scpS.setVisible(false);
        List entries = ce.keySet().stream().map(k -> func.apply((String)k, ce.getEntry((String)k))).collect(Collectors.toList());
        if (current != null && !ce.hasEntry(getKey.apply(current))) {
            entries.add(current);
        }
        ListPanel playerList = new ListPanel(this.gui, entries, w, panel.getBounds().h - 30);
        playerList.setGetTooltip(tooltip);
        Consumer<Object> selEvt = s -> {
            if (s != null) {
                playerList.setWidth(lw);
                HashMap<String, Object> f = new HashMap<String, Object>(fieldsIn);
                if (fieldsIn.containsKey("nameBoxInit")) {
                    f.put("nameBox", s.toString());
                }
                scpS.setDisplay(new SafetyHeaderPanel(this.frm, ce.getEntry((String)getKey.apply(s)), spw, this.gui.i18nFormat("label.cpm.sSettingsFor", s.toString()), f, (PlayerSpecificConfigKey.KeyGroup)((Object)((Object)getKg.apply(s))), this.ce));
            } else {
                playerList.setWidth(w);
            }
            scpS.setVisible(s != null);
        };
        playerList.setSelect(selEvt);
        playerList.setBounds(new Box(0, 0, w, panel.getBounds().h - 30));
        playerList.setWidth(w);
        if (current != null) {
            playerList.setSelected(current);
            selEvt.accept(current);
        }
        ButtonIcon newBtn = new ButtonIcon(this.gui, "editor", 0, 16, () -> this.frm.openPopup(new InputPopup(this.frm, this.gui.i18nFormat("label.cpm.enterServerIP", new Object[0]), key -> {
            if (!ce.keySet().contains(key)) {
                ConfigEntry ne = ce.getEntry((String)key);
                Object newE = func.apply((String)key, ne);
                entries.add(newE);
                playerList.setSelected(newE);
                selEvt.accept(newE);
                playerList.refreshList();
            }
        }, null)));
        newBtn.setEnabled(enableAdd);
        newBtn.setBounds(new Box(5, panel.getBounds().h - 25, 18, 18));
        ButtonIcon delBtn = new ButtonIcon(this.gui, "editor", 14, 16, () -> {
            Object elem = playerList.getSelected();
            if (elem != null) {
                ConfirmPopup.confirm(this.frm, this.gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> {
                    entries.remove(elem);
                    ce.clearValue((String)getKey.apply(elem));
                    scpS.setVisible(false);
                    playerList.setWidth(w);
                    playerList.refreshList();
                });
            }
        });
        delBtn.setBounds(new Box(30, panel.getBounds().h - 25, 18, 18));
        panel.addElement(playerList);
        panel.addElement(newBtn);
        panel.addElement(delBtn);
        panel.addElement(scpS);
    }

    private static Map<String, Object> createMap(Object ... dataIn) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < dataIn.length; i += 2) {
            String key = (String)dataIn[i];
            Object v = dataIn[i + 1];
            data.put(key, v);
        }
        return data;
    }

    public boolean isChanged() {
        return this.ce.isDirty();
    }

    public void setOpenTab(int tabID) {
        ((Button)this.topPanel.getPanel().getElements().get(tabID)).getAction().run();
    }

    private static class Srv {
        private String ip;
        private String name;

        public Srv(String ip, String name) {
            this.ip = ip;
            this.name = name;
        }

        public Srv(String ip) {
            this.ip = ip;
            this.name = Util.hideIp(ip);
        }

        public String toString() {
            return this.name;
        }
    }

    private class Pl {
        private String uuid;
        private String name;

        public Pl(String uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        public PlayerSpecificConfigKey.KeyGroup getKeyGroup() {
            return SettingsPanel.this.ce.getEntry("friendList").keySet().contains(this.uuid) ? PlayerSpecificConfigKey.KeyGroup.FRIEND : PlayerSpecificConfigKey.KeyGroup.GLOBAL;
        }

        public String toString() {
            return this.name;
        }
    }
}

