/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.gui.panel.SafetyPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;

public class SafetyHeaderPanel
extends Panel {
    private ConfigEntry main;
    private SafetyPanel sp;
    private Frame frm;
    private Button btnProfile;
    private Button btnDelP;
    private Panel namePanel;
    private PlayerSpecificConfigKey.KeyGroup keyGroup;

    public SafetyHeaderPanel(Frame frm, ConfigEntry ce, int w, String title, Map<String, Object> fields, PlayerSpecificConfigKey.KeyGroup keyGroup, ConfigEntry main) {
        super(frm.getGui());
        this.frm = frm;
        this.keyGroup = keyGroup;
        this.setBounds(new Box(0, 0, w, 0));
        this.main = main;
        FlowLayout layout = new FlowLayout(this, 5, 1);
        this.addElement(new Label(this.gui, title).setBounds(new Box(1, 0, 100, 10)));
        if (fields.containsKey("nameBox")) {
            Panel panel = new Panel(this.gui);
            this.addElement(panel);
            panel.setBounds(new Box(0, 0, 170, 30));
            panel.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0])).setBounds(new Box(5, 0, 0, 0)));
            TextField txt = new TextField(this.gui);
            txt.setText(ce.getString("name", (String)fields.get("nameBox")));
            txt.setBounds(new Box(5, 10, 160, 20));
            panel.addElement(txt);
            txt.setEventListener(() -> ce.setString("name", txt.getText()));
        }
        if (fields.containsKey("server")) {
            Checkbox chbxIgnoreSafetyRec = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.safety.ignoreServerSafetySettings", new Object[0]));
            chbxIgnoreSafetyRec.setAction(() -> {
                boolean v = !chbxIgnoreSafetyRec.isSelected();
                chbxIgnoreSafetyRec.setSelected(v);
                ce.setBoolean("ignoreSafetyRec", v);
            });
            chbxIgnoreSafetyRec.setSelected(ce.getBoolean("ignoreSafetyRec", false));
            chbxIgnoreSafetyRec.setBounds(new Box(5, 0, 170, 20));
            this.addElement(chbxIgnoreSafetyRec);
            Checkbox chbxDisableNetwork = new Checkbox(this.gui, this.gui.i18nFormat("label.cpm.safety.blockNetwork", new Object[0]));
            chbxDisableNetwork.setAction(() -> {
                boolean v = !chbxDisableNetwork.isSelected();
                chbxDisableNetwork.setSelected(v);
                ce.setBoolean("disableNet", v);
            });
            chbxDisableNetwork.setSelected(ce.getBoolean("disableNet", false));
            chbxDisableNetwork.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.safety.blockNetwork", new Object[0])));
            chbxDisableNetwork.setBounds(new Box(5, 0, 170, 20));
            this.addElement(chbxDisableNetwork);
        }
        if (fields.containsKey("safetyBtn")) {
            ArrayList<String> profiles = new ArrayList<String>();
            for (BuiltInSafetyProfiles p : BuiltInSafetyProfiles.VALUES) {
                if (p == BuiltInSafetyProfiles.CUSTOM) continue;
                profiles.add(p.name().toLowerCase());
            }
            ConfigEntry spfs = (ConfigEntry)fields.get("safetyBtn");
            String server = MinecraftClientAccess.get().getConnectedServer();
            spfs.keySet().stream().filter(k -> {
                ConfigEntry e = spfs.getEntry((String)k);
                if (e.getBoolean("imported", false)) {
                    return k.equals("import-" + server);
                }
                return true;
            }).map(e -> "custom:" + e).forEach(profiles::add);
            Supplier<String> current = () -> ce.getString("safetyProfile", BuiltInSafetyProfiles.MEDIUM.name().toLowerCase());
            this.btnProfile = new Button(this.gui, "", null);
            this.btnProfile.setBounds(new Box(5, 0, w - 10, 20));
            Panel ctrls = new Panel(this.gui);
            ctrls.setBounds(new Box(0, 0, w, 20));
            Button newP = new Button(this.gui, this.gui.i18nFormat("button.cpm.safety.newProfile", new Object[0]), new InputPopup(frm, this.gui.i18nFormat("label.cpm.name", new Object[0]), this.gui.i18nFormat("label.cpm.safetyProfileName", new Object[0]), name -> {
                if (!name.isEmpty()) {
                    String id = UUID.randomUUID().toString();
                    String profile = "custom:" + id;
                    profiles.add(profile);
                    this.initNewProfile(spfs, id, (String)name, (String)current.get());
                    ce.setString("safetyProfile", profile);
                    this.setupProfile(profile, spfs);
                    layout.reflow();
                }
            }, null));
            newP.setBounds(new Box(5, 0, 70, 20));
            ctrls.addElement(newP);
            this.btnDelP = new Button(this.gui, this.gui.i18nFormat("button.cpm.safety.deleteProfile", new Object[0]), new ConfirmPopup(frm, this.gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> {
                String[] spf = ((String)current.get()).split(":");
                BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
                if (profile == BuiltInSafetyProfiles.CUSTOM) {
                    String profileN = (String)profiles.get((profiles.indexOf(current.get()) + 1) % profiles.size());
                    ce.setString("safetyProfile", profileN);
                    this.setupProfile(profileN, spfs);
                    layout.reflow();
                    profiles.remove("custom:" + spf[1]);
                    spfs.clearValue(spf[1]);
                }
            }, null));
            this.btnDelP.setBounds(new Box(80, 0, 70, 20));
            ctrls.addElement(this.btnDelP);
            this.addElement(this.btnProfile);
            this.addElement(ctrls);
            this.btnProfile.setAction(() -> {
                String profile = (String)profiles.get((profiles.indexOf(current.get()) + 1) % profiles.size());
                ce.setString("safetyProfile", profile);
                this.setupProfile(profile, spfs);
                layout.reflow();
            });
            this.setupProfile(current.get(), spfs);
        } else {
            this.addElement(new SafetyPanel(this.gui, ce, w, keyGroup, null, main));
        }
        layout.reflow();
    }

    private void initNewProfile(ConfigEntry spfs, String id, String name, String currentProfile) {
        ConfigEntry ce = spfs.getEntry(id);
        ce.setString("name", name);
        String[] spf = currentProfile.split(":");
        BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
        if (profile == BuiltInSafetyProfiles.CUSTOM) {
            ConfigEntry old = spfs.getEntry(spf[1]);
            for (PlayerSpecificConfigKey key : ConfigKeys.SAFETY_KEYS) {
                key.copyValue(old, ce);
            }
        } else {
            profile.copyTo(ce);
        }
    }

    private void setupProfile(String profileIn, ConfigEntry spfs) {
        String txt;
        String[] spf = profileIn.split(":");
        BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
        if (this.sp != null) {
            this.remove(this.sp);
        }
        if (this.namePanel != null) {
            this.remove(this.namePanel);
        }
        boolean custom = profile == BuiltInSafetyProfiles.CUSTOM;
        this.btnDelP.setEnabled(custom);
        if (custom) {
            ConfigEntry ce = spfs.getEntry(spf[1]);
            this.sp = new SafetyPanel(this.gui, ce, this.bounds.w, this.keyGroup, null, this.main);
            String name = ce.getString("name", "???");
            txt = this.gui.i18nFormat("label.cpm.safetyProfile.custom", name);
            this.namePanel = new Panel(this.gui);
            this.addElement(this.namePanel);
            this.namePanel.setBounds(new Box(0, 0, 170, 30));
            this.namePanel.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.name", new Object[0])).setBounds(new Box(5, 0, 0, 0)));
            TextField txtF = new TextField(this.gui);
            txtF.setText(name);
            txtF.setBounds(new Box(5, 10, 160, 20));
            this.namePanel.addElement(txtF);
            txtF.setEventListener(() -> ce.setString("name", txtF.getText()));
        } else {
            ConfigEntry dummy = new ConfigEntry(new HashMap<String, Object>(), () -> {});
            profile.copyTo(dummy);
            this.sp = new SafetyPanel(this.gui, dummy, this.bounds.w, this.keyGroup, null, this.main);
            this.sp.setEnabled(false);
            txt = this.gui.i18nFormat("label.cpm.safetyProfile." + profile.name().toLowerCase(), new Object[0]);
        }
        this.btnProfile.setText(this.gui.i18nFormat("button.cpm.safetyProfile", txt));
        this.btnProfile.setTooltip(!custom ? new Tooltip(this.frm, this.gui.i18nFormat("tooltip.cpm.safetyProfile." + profile.name().toLowerCase(), new Object[0])) : null);
        this.addElement(this.sp);
    }
}

