/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpm.shared.config.Keybind;

public class KeybindPopup
extends MessagePopup {
    private Keybind kb;
    private ConfigEntry ce;
    private int modKeys;

    public KeybindPopup(Frame frame, ConfigEntry ce, Keybind kb) {
        super(frame, frame.getGui().i18nFormat("label.cpm.setKeybind.title", new Object[0]), frame.getGui().i18nFormat("label.cpm.setKeybind.desc", new Object[0]), frame.getGui().i18nFormat("button.cpm.cancel", new Object[0]));
        this.ce = ce;
        this.kb = kb;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        super.draw(event, partialTicks);
        if (this.modKeys > 0) {
            if ((this.modKeys & 1) != 0 && !this.gui.isShiftDown()) {
                this.kb.setKey(this.ce, new KeyboardEvent(this.gui.getKeyCodes().KEY_LEFT_SHIFT, 0, '\u0000', null), this.modKeys & 0xFFFFFFFE);
                this.close();
                return;
            }
            if ((this.modKeys & 2) != 0 && !this.gui.isCtrlDown()) {
                this.kb.setKey(this.ce, new KeyboardEvent(this.gui.getKeyCodes().KEY_LEFT_CONTROL, 0, '\u0000', null), this.modKeys & 0xFFFFFFFD);
                this.close();
                return;
            }
            if ((this.modKeys & 4) != 0 && !this.gui.isAltDown()) {
                this.kb.setKey(this.ce, new KeyboardEvent(this.gui.getKeyCodes().KEY_LEFT_ALT, 0, '\u0000', null), this.modKeys & 0xFFFFFFFB);
                this.close();
                return;
            }
        }
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (event.keyCode == this.gui.getKeyCodes().KEY_LEFT_SHIFT || event.keyCode == this.gui.getKeyCodes().KEY_RIGHT_SHIFT) {
            this.modKeys |= 1;
            event.consume();
            return;
        }
        if (event.keyCode == this.gui.getKeyCodes().KEY_LEFT_CONTROL || event.keyCode == this.gui.getKeyCodes().KEY_RIGHT_CONTROL) {
            this.modKeys |= 2;
            event.consume();
            return;
        }
        if (event.keyCode == this.gui.getKeyCodes().KEY_LEFT_ALT || event.keyCode == this.gui.getKeyCodes().KEY_RIGHT_ALT) {
            this.modKeys |= 4;
            event.consume();
            return;
        }
        if (event.keyCode == this.gui.getKeyCodes().KEY_ESCAPE) {
            this.kb.unbindKey(this.ce);
        } else {
            this.kb.setKey(this.ce, event, this.modKeys);
        }
        this.close();
        event.consume();
    }
}

