/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.IManualGesture;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.TestIngameManager;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.FirstPersonHandPosGui;
import com.tom.cpm.shared.gui.ModelsGui;
import com.tom.cpm.shared.gui.RecommendSafetySettingsPopup;
import com.tom.cpm.shared.gui.SettingsGui;
import com.tom.cpm.shared.gui.SocialGui;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.util.ArrayList;
import java.util.List;

public class GestureGui
extends Frame {
    private GestureButton hoveredBtn;
    private Panel panel;
    private Panel contentPanel;
    private int tickCounter;
    private ModelDefinition def;
    private ModelDefinition.ModelLoadingState state;

    public GestureGui(IGui gui) {
        super(gui);
        gui.setCloseListener(r -> {
            ModConfig.getCommonConfig().save();
            r.run();
        });
        this.tickCounter = 3;
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.hoveredBtn != null) {
            ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
            String hoveredID = this.hoveredBtn.gesture.getGestureId();
            String keybindPressed = null;
            ArrayList<String> dup = new ArrayList<String>();
            for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                if (!kb.getName().startsWith("qa")) continue;
                if (kb.isPressed(event)) {
                    keybindPressed = kb.getName();
                    continue;
                }
                String c = ce.getString(kb.getName(), null);
                if (c == null || !c.equals(hoveredID)) continue;
                dup.add(kb.getName());
            }
            if (keybindPressed != null) {
                ce.setString(keybindPressed, hoveredID);
                ce.setString(keybindPressed + "_mode", !this.hoveredBtn.layer && this.gui.isCtrlDown() ? "hold" : "press");
                for (String k : dup) {
                    ce.setString(k, "");
                }
            }
            this.panel.getElements().forEach(e -> ((GestureButton)e).getKb());
        }
        super.keyPressed(event);
    }

    @Override
    public void tick() {
        if (this.tickCounter > 0) {
            --this.tickCounter;
            if (TestIngameManager.isTesting() && this.gui.isShiftDown()) {
                MinecraftClientAccess.get().openGui(EditorGui::new);
                return;
            }
            if (TestIngameManager.isTesting() && this.gui.isCtrlDown()) {
                MinecraftClientAccess.get().openGui(FirstPersonHandPosGui::new);
                return;
            }
            List<ConfigChangeRequest<?, ?>> changes = MinecraftClientAccess.get().getNetHandler().getRecommendedSettingChanges();
            String server = MinecraftClientAccess.get().getConnectedServer();
            if (server != null && !changes.isEmpty()) {
                this.openPopup(new RecommendSafetySettingsPopup(this.gui, server, changes));
                this.tickCounter = 0;
            }
        }
    }

    @Override
    public void initFrame(int width, int height) {
        this.contentPanel = new Panel(this.gui);
        this.contentPanel.setBounds(new Box(0, 0, width, height));
        this.def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition0();
        this.initContent(this.contentPanel);
        this.addElement(this.contentPanel);
    }

    private void initContent(Panel p) {
        String k;
        int h;
        MinecraftClientAccess.ServerStatus status;
        int width = p.getBounds().w;
        int height = p.getBounds().h;
        Log.debug(this.def);
        if (this.def != null) {
            this.state = this.def.getResolveState();
        }
        if ((status = MinecraftClientAccess.get().getServerSideStatus()) == MinecraftClientAccess.ServerStatus.OFFLINE) {
            String str = "How did you get here?";
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("qa")) continue;
            ++i;
            String k2 = kb.getBoundKey();
            if (k2.isEmpty()) {
                k2 = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            }
            keys.add(this.gui.i18nFormat("label.cpm.quick_key_bound", i, k2));
        }
        ++i;
        keys.add(this.gui.i18nFormat("label.cpm.quick_key_info", new Object[0]));
        if ((this.bounds.w - 360) / 2 > 100) {
            tt = this.gui.i18nFormat("tooltip.cpm.gestureQuickAccess", new Object[0]);
            Panel qk = new Panel(this.gui);
            int i2 = 0;
            int mw = 0;
            for (String k3 : keys) {
                qk.addElement(new Label(this.gui, k3).setBounds(new Box(0, ++i2 * 10, 0, 10)));
                mw = Math.max(this.gui.textWidth(k3), mw);
            }
            qk.setBounds(new Box(10, 0, 200, ++i2 * 10));
            Label lbl = new Label(this.gui, "");
            lbl.setTooltip(new Tooltip(this, (String)tt));
            qk.addElement(lbl.setBounds(new Box(0, 0, 200, i2 * 10)));
            p.addElement(qk);
        } else {
            tt = new StringBuilder();
            for (String key : keys) {
                ((StringBuilder)tt).append(key);
                ((StringBuilder)tt).append('\\');
            }
            ((StringBuilder)tt).append(this.gui.i18nFormat("label.cpm.quick_key_info", new Object[0]));
            ((StringBuilder)tt).append("\\\\");
            ((StringBuilder)tt).append(this.gui.i18nFormat("tooltip.cpm.gestureQuickAccess", new Object[0]));
            String text = this.gui.i18nFormat("label.cpm.quick_key_short", new Object[0]);
            Label lbl = new Label(this.gui, text);
            lbl.setTooltip(new Tooltip(this, ((StringBuilder)tt).toString()));
            p.addElement(lbl.setBounds(new Box(10, 10, this.gui.textWidth(text), 10)));
        }
        if (this.def != null && this.state == ModelDefinition.ModelLoadingState.LOADED && status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            int[] id = new int[]{0};
            this.panel = new Panel(this.gui);
            this.def.getAnimations().getGestures().forEach((nm, g) -> {
                int n = id[0];
                id[0] = n + 1;
                this.panel.addElement(new GestureButton((IManualGesture)g, n));
            });
            this.def.getAnimations().getCustomPoses().forEach((nm, g) -> {
                int n = id[0];
                id[0] = n + 1;
                this.panel.addElement(new GestureButton((IManualGesture)g, n));
            });
            if (id[0] == 0) {
                String str = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
                Label lbl = new Label(this.gui, str);
                lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
                p.addElement(lbl);
                h = 10;
            } else {
                h = (id[0] / 4 + 1) * 40;
                if (h < height - 150) {
                    this.panel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2, 360, h));
                    p.addElement(this.panel);
                } else {
                    this.panel.setBounds(new Box(0, 0, 360, h));
                    ScrollPanel scp = new ScrollPanel(this.gui);
                    h = height - 120;
                    scp.setBounds(new Box(width / 2 - 180, 60, 363, height - 150));
                    scp.setDisplay(this.panel);
                    p.addElement(scp);
                }
            }
        } else if (this.def != null && (this.state == ModelDefinition.ModelLoadingState.ERRORRED || this.state == ModelDefinition.ModelLoadingState.SAFETY_BLOCKED)) {
            String txt = "";
            switch (this.state) {
                case ERRORRED: {
                    txt = this.gui.i18nFormat("label.cpm.errorLoadingModel", this.def.getError().toString());
                    break;
                }
                case SAFETY_BLOCKED: {
                    txt = this.gui.i18nFormat("label.cpm.safetyBlocked", new Object[0]);
                    break;
                }
            }
            p.addElement(new Label(this.gui, txt).setBounds(new Box(width / 2 - this.gui.textWidth(txt) / 2, height / 2 - 4, 0, 0)));
            txt = this.gui.i18nFormat("label.cpm.checkErrorLog", new Object[0]);
            p.addElement(new Label(this.gui, txt).setBounds(new Box(width / 2 - this.gui.textWidth(txt) / 2, height / 2 - 4 + 10, 0, 0)));
            h = 20;
        } else if (status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            str = this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0]);
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            h = 10;
        } else {
            str = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            h = 10;
        }
        Panel btnPanel = new Panel(this.gui);
        btnPanel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2 - 30, 360, 20));
        p.addElement(btnPanel);
        if (status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            Button btnRstG = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_gesture", new Object[0]), this::clearGesture);
            btnRstG.setBounds(new Box(0, 0, 100, 20));
            btnPanel.addElement(btnRstG);
            Button btnRstP = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_pose", new Object[0]), this::clearPose);
            btnRstP.setBounds(new Box(110, 0, 100, 20));
            btnPanel.addElement(btnRstP);
        }
        Checkbox chbxNames = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_name", new Object[0]));
        chbxNames.setBounds(new Box(220, 0, 70, 20));
        chbxNames.setSelected(Player.isEnableNames());
        chbxNames.setAction(() -> {
            boolean v = !chbxNames.isSelected();
            chbxNames.setSelected(v);
            Player.setEnableNames(v);
        });
        btnPanel.addElement(chbxNames);
        Panel btnPanel2 = new Panel(this.gui);
        btnPanel2.setBounds(new Box(width - 162, 0, 160, 0));
        p.addElement(btnPanel2);
        FlowLayout fl = new FlowLayout(btnPanel2, 0, 1);
        Button btnSafety = new Button(this.gui, this.gui.i18nFormat("button.cpm.safetySettings", new Object[0]), () -> MinecraftClientAccess.get().openGui(SettingsGui::safetySettings));
        btnSafety.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnSafety);
        Button btnSocial = new Button(this.gui, this.gui.i18nFormat("button.cpm.socialMenu", new Object[0]), () -> MinecraftClientAccess.get().openGui(SocialGui::new));
        btnSocial.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnSocial);
        Button btnCleanCache = new Button(this.gui, this.gui.i18nFormat("button.cpm.reload_models", new Object[0]), MinecraftClientAccess.get().getDefinitionLoader()::clearCache);
        btnCleanCache.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnCleanCache);
        IKeybind rtkb = null;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("renderToggle")) continue;
            rtkb = kb;
        }
        String string = k = rtkb == null ? "?" : rtkb.getBoundKey();
        if (k.isEmpty()) {
            k = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
        }
        Checkbox chbxRender = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_models", k));
        chbxRender.setBounds(new Box(0, 0, 160, 20));
        chbxRender.setSelected(Player.isEnableRendering());
        chbxRender.setAction(() -> {
            boolean v = !chbxRender.isSelected();
            chbxRender.setSelected(v);
            Player.setEnableRendering(v);
        });
        btnPanel2.addElement(chbxRender);
        fl.reflow();
        Box bp2 = btnPanel2.getBounds();
        btnPanel2.setBounds(new Box(bp2.x, height - bp2.h - 2, bp2.w, bp2.h));
        Panel btnPanel3 = new Panel(this.gui);
        btnPanel3.setBounds(new Box(0, height - 60, 160, 60));
        p.addElement(btnPanel3);
        Button btnSkinMenu = new Button(this.gui, this.gui.i18nFormat("button.cpm.models", new Object[0]), () -> MinecraftClientAccess.get().openGui(ModelsGui::new));
        btnSkinMenu.setBounds(new Box(0, 40, 160, 20));
        btnPanel3.addElement(btnSkinMenu);
        if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
            btnSkinMenu.setEnabled(false);
            btnSkinMenu.setTooltip(new Tooltip(this, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
        }
        if (TestIngameManager.isTesting()) {
            Button btnOpenEditor = new Button(this.gui, this.gui.i18nFormat("button.cpm.open_editor", new Object[0]), () -> MinecraftClientAccess.get().openGui(EditorGui::new));
            btnOpenEditor.setBounds(new Box(0, 20, 160, 20));
            btnPanel3.addElement(btnOpenEditor);
            Button btnOpenFP = new Button(this.gui, this.gui.i18nFormat("button.cpm.effect.setFpHandPos", new Object[0]), () -> MinecraftClientAccess.get().openGui(FirstPersonHandPosGui::new));
            btnOpenFP.setBounds(new Box(0, 0, 160, 20));
            btnPanel3.addElement(btnOpenFP);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        TextureProvider skin;
        this.hoveredBtn = null;
        super.draw(event, partialTicks);
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition0();
        if (def != this.def || def != null && def.getResolveState() != this.state) {
            this.contentPanel.getElements().clear();
            this.def = def;
            this.initContent(this.contentPanel);
        }
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isAltDown() && def != null && (skin = def.getTexture(TextureSheetType.SKIN, true)) != null && skin.texture != null) {
            skin.bind();
            int size = Math.min(this.bounds.w, this.bounds.h);
            this.gui.drawText(514, 2, "Stitched: " + def.isStitchedTexture(), -1);
            this.gui.drawBox(0, 0, size, size, -5592406);
            this.gui.drawTexture(0, 0, size, size, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    private void clearGesture() {
        if (this.def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().playGesture(this.def.getAnimations(), null);
        }
    }

    private void clearPose() {
        if (this.def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setCustomPose(this.def.getAnimations(), null);
        }
    }

    private void setManualGesture(IManualGesture g) {
        if (this.def != null) {
            g.play(this.def.getAnimations());
        }
    }

    private class GestureButton
    extends Panel {
        private IManualGesture gesture;
        private String kb;
        private String kbMode;
        private String name;
        private boolean layer;
        private boolean value;

        public GestureButton(int id) {
            super(GestureGui.this.gui);
            this.setBounds(new Box(id % 4 * 90, id / 4 * 40, 80, 30));
        }

        public GestureButton(IManualGesture g, int id) {
            this(id);
            Button btn;
            String nm = g.getName();
            if (g instanceof Gesture) {
                this.layer = nm.startsWith("$layer$");
                this.value = nm.startsWith("$value$");
            }
            if (this.layer) {
                nm = nm.substring("$layer$".length());
            } else if (this.value) {
                nm = nm.substring("$value$".length());
            } else {
                btn = new Button(this.gui, "", () -> GestureGui.this.setManualGesture(g));
                btn.setBounds(new Box(0, 0, this.bounds.w, this.bounds.h));
                this.addElement(btn);
            }
            this.name = nm;
            this.gesture = g;
            this.getKb();
            if (this.layer || this.value) {
                if (!MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
                    this.setEnabled(false);
                    s = new Slider(this.gui, nm);
                    s.setBounds(new Box(0, 0, this.bounds.w, this.bounds.h));
                    s.setEnabled(false);
                    s.setTooltip(new Tooltip(gestureGui, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
                    this.addElement(s);
                } else if (this.value) {
                    s = new Slider(this.gui, nm);
                    s.setBounds(new Box(0, 0, this.bounds.w, this.bounds.h));
                    s.setAction(() -> {
                        if (GestureGui.this.def != null) {
                            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setLayerValue(GestureGui.this.def.getAnimations(), (Gesture)g, s.getValue());
                        }
                    });
                    if (gestureGui.def != null) {
                        s.setValue((float)Byte.toUnsignedInt(MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getGestureValue(gestureGui.def.getAnimations(), (Gesture)g)) / 255.0f);
                    }
                    this.addElement(s);
                } else if (this.layer) {
                    btn = new Button(this.gui, "", () -> GestureGui.this.setManualGesture(g));
                    btn.setBounds(new Box(0, 0, this.bounds.w, this.bounds.h));
                    this.addElement(btn);
                }
            }
        }

        public void getKb() {
            ConfigEntry ce = ModConfig.getCommonConfig().getEntry("keybinds");
            this.kb = null;
            this.kbMode = null;
            for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                String c;
                if (!kb.getName().startsWith("qa") || (c = ce.getString(kb.getName(), null)) == null || !c.equals(this.gesture.getGestureId())) continue;
                this.kb = kb.getName();
                this.kbMode = ce.getString(kb.getName() + "_mode", "press");
                break;
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            if (this.value) {
                super.draw(event, partialTicks);
                return;
            }
            int w = this.gui.textWidth(this.name);
            int bgColor = this.gui.getColors().button_fill;
            int color = this.gui.getColors().button_text_color;
            if (!this.enabled) {
                color = this.gui.getColors().button_text_disabled;
                bgColor = this.gui.getColors().button_disabled;
            } else if (event.isHovered(this.bounds)) {
                color = this.gui.getColors().button_text_hover;
                bgColor = this.gui.getColors().button_hover;
            }
            this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
            if (this.layer) {
                if (GestureGui.this.def != null) {
                    boolean on = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getGestureValue(GestureGui.this.def.getAnimations(), (Gesture)this.gesture) != 0;
                    int bw = this.bounds.w - 2;
                    this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, bw / 2, this.bounds.h - 2, on ? -16711936 : bgColor);
                    this.gui.drawBox(this.bounds.x + 1 + bw / 2, this.bounds.y + 1, bw / 2, this.bounds.h - 2, on ? bgColor : -65536);
                }
            } else {
                this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
            }
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 8, this.name, color);
            String boundKey = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            if (this.kb != null) {
                for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
                    if (!kb.getName().equals(this.kb)) continue;
                    String k = kb.getBoundKey();
                    if (k.isEmpty()) {
                        k = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
                    }
                    boundKey = k;
                    this.gui.drawText(this.bounds.x + this.bounds.w / 2 - w / 2, this.bounds.y + this.bounds.h / 2 + 4, k, color);
                    break;
                }
            }
            if (event.isHovered(this.bounds)) {
                if (!this.enabled) {
                    new Tooltip(GestureGui.this, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])).set();
                } else {
                    String kbMode;
                    GestureGui.this.hoveredBtn = this;
                    String string = kbMode = this.kbMode != null ? this.gui.i18nFormat("label.cpm.gestureMode." + this.kbMode, new Object[0]) : this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
                    if (this.layer) {
                        new Tooltip(GestureGui.this, this.gui.i18nFormat("tooltip.cpm.gestureButton", this.name, boundKey)).set();
                    } else {
                        new Tooltip(GestureGui.this, this.gui.i18nFormat("tooltip.cpm.gestureButton.mode", this.name, boundKey, kbMode)).set();
                    }
                }
            }
        }
    }
}

