/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.effects;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.effects.IRenderEffect;
import com.tom.cpm.shared.effects.RenderEffects;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.RenderedCube;
import java.io.IOException;

public class EffectUV
implements IRenderEffect {
    private int id;
    private int u;
    private int v;

    public EffectUV() {
    }

    public EffectUV(int id, int u, int v) {
        this.id = id;
        this.u = u;
        this.v = v;
    }

    @Override
    public void load(IOHelper in) throws IOException {
        this.id = in.readVarInt();
        this.u = in.readVarInt();
        this.v = in.readVarInt();
    }

    @Override
    public void write(IOHelper out) throws IOException {
        out.writeVarInt(this.id);
        out.writeVarInt(this.u);
        out.writeVarInt(this.v);
    }

    @Override
    public void apply(ModelDefinition def) {
        RenderedCube cube = def.getElementById(this.id);
        if (cube != null) {
            cube.getCube().u = this.u;
            cube.getCube().v = this.v;
        }
    }

    @Override
    public RenderEffects getEffect() {
        return RenderEffects.UV_OVERFLOW;
    }

    public String toString() {
        return "UV [" + this.id + "] UV[" + this.u + ", " + this.v + "]";
    }
}

