/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec3f;
import com.tom.cpl.math.Vec4f;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.tree.TreeElement;
import java.util.ArrayList;
import java.util.List;

public abstract class UVResizableArea {
    protected final Editor editor;
    protected final TreeElement parent;
    public final TreeElement.TreeSettingElement face;
    public final List<TreeElement.TreeSettingElement> elements;

    public UVResizableArea(Editor editor, TreeElement parent) {
        int i;
        this.editor = editor;
        this.parent = parent;
        this.face = this.face();
        this.elements = new ArrayList<TreeElement.TreeSettingElement>();
        for (i = 0; i < 4; ++i) {
            this.elements.add(new CornerArea(editor, parent, i));
        }
        for (i = 0; i < 4; ++i) {
            this.elements.add(new SideArea(editor, parent, i));
        }
        this.elements.add(this.face);
    }

    protected abstract Area getArea();

    protected abstract void setArea(Area var1, boolean var2);

    protected abstract void setAreaTemp(Area var1);

    protected FaceArea face() {
        return new FaceArea(this.editor, this.parent);
    }

    protected SideArea side(int i) {
        return new SideArea(this.editor, this.parent, i);
    }

    protected CornerArea corner(int i) {
        return new CornerArea(this.editor, this.parent, i);
    }

    public static Vec4f expandBox(Box b, float zoom) {
        if (b.w == 0 || b.h == 0) {
            float sx = b.x;
            float sy = b.y;
            float w = b.w;
            float h = b.h;
            float ex = 2.0f / zoom;
            if (b.w == 0) {
                sx -= ex;
                w = ex * 2.0f;
            }
            if (b.h == 0) {
                sy -= ex;
                h = ex * 2.0f;
            }
            if (b.w == 0 && b.h == 0) {
                sx -= ex;
                w = ex * 4.0f;
                sy -= ex;
                h = ex * 4.0f;
            }
            return new Vec4f(sx, sy, w, h);
        }
        return new Vec4f(b.x, b.y, b.w, b.h);
    }

    public static boolean isHovered(Box b, float x, float y, float zoom) {
        if (b == null) {
            return false;
        }
        if (b.w == 0 || b.h == 0) {
            Vec4f e = UVResizableArea.expandBox(b, zoom);
            return e.x <= x && e.y <= y && e.x + e.z > x && e.y + e.w > y;
        }
        return b.isInBounds((int)x, (int)y);
    }

    protected class FaceArea
    extends BaseArea {
        public FaceArea(Editor editor, TreeElement parent) {
            super(editor, parent);
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(f.sx, f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setArea(f, true);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                int x = (int)vec.x - f.sx;
                int y = (int)vec.y - f.sy;
                f.sx += x;
                f.sy += y;
                f.ex += x;
                f.ey += y;
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            int sx = Math.min(f.sx, f.ex);
            int sy = Math.min(f.sy, f.ey);
            int ex = Math.max(f.sx, f.ex);
            int ey = Math.max(f.sy, f.ey);
            return new Box(sx, sy, ex - sx, ey - sy);
        }
    }

    protected class CornerArea
    extends BaseArea {
        private int corner;

        public CornerArea(Editor editor, TreeElement parent, int corner) {
            super(editor, parent);
            this.corner = corner;
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(this.corner % 2 != 0 ? (float)f.ex : (float)f.sx, this.corner > 1 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.corner % 2 != 0) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                if (this.corner > 1) {
                    f.ey = (int)vec.y;
                } else {
                    f.sy = (int)vec.y;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.corner % 2 != 0 ? f.ex : f.sx, this.corner > 1 ? f.ey : f.sy, 0, 0);
        }
    }

    protected class SideArea
    extends BaseArea {
        private int side;

        public SideArea(Editor editor, TreeElement parent, int side) {
            super(editor, parent);
            this.side = side;
        }

        @Override
        public Vec3f getVec(TreeElement.VecType type) {
            Area f = UVResizableArea.this.getArea();
            if (type == TreeElement.VecType.TEXTURE) {
                return new Vec3f(this.side > 1 && this.side % 2 != 0 ? (float)f.ex : (float)f.sx, this.side > 1 && this.side % 2 == 0 ? (float)f.ey : (float)f.sy, 1.0f);
            }
            return Vec3f.ZERO;
        }

        @Override
        public void setVec(Vec3f vec, TreeElement.VecType object) {
            if (object == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setArea(f, false);
            }
        }

        @Override
        public void setVecTemp(TreeElement.VecType type, Vec3f vec) {
            if (type == TreeElement.VecType.TEXTURE) {
                Area f = UVResizableArea.this.getArea();
                if (this.side % 2 == 0) {
                    if (this.side > 1) {
                        f.ey = (int)vec.y;
                    } else {
                        f.sy = (int)vec.y;
                    }
                } else if (this.side > 1) {
                    f.ex = (int)vec.x;
                } else {
                    f.sx = (int)vec.x;
                }
                UVResizableArea.this.setAreaTemp(f);
            }
        }

        @Override
        public Box getTextureBox() {
            Area f = UVResizableArea.this.getArea();
            return new Box(this.side > 1 && this.side % 2 != 0 ? f.ex : f.sx, this.side > 1 && this.side % 2 == 0 ? f.ey : f.sy, this.side % 2 == 0 ? f.ex - f.sx : 0, this.side % 2 != 0 ? f.ey - f.sy : 0);
        }
    }

    private abstract class BaseArea
    implements TreeElement.TreeSettingElement {
        protected final Editor editor;
        protected final TreeElement parent;

        public BaseArea(Editor editor, TreeElement parent) {
            this.editor = editor;
            this.parent = parent;
        }

        @Override
        public TreeElement getParent() {
            return this.parent;
        }

        @Override
        public void drawTexture(IGui gui, int x, int y, float xs, float ys) {
            if (this.editor.selectedElement == this) {
                TreeElement.TreeSettingElement.super.drawTexture(gui, x, y, xs, ys);
            }
            Box b = this.getTextureBox();
            Vec4f v = UVResizableArea.expandBox(b, xs);
            gui.drawRectangle((float)x + v.x * xs, (float)y + v.y * ys, v.z * xs, v.w * ys, -6710887);
        }
    }

    public static class Area {
        public int sx;
        public int sy;
        public int ex;
        public int ey;

        public Area(int sx, int sy, int ex, int ey) {
            this.sx = sx;
            this.sy = sy;
            this.ex = ex;
            this.ey = ey;
        }
    }
}

