/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.util;

import com.tom.cpl.text.FormatText;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.util.SafetyChecks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SafetyLevel {
    MEDIUM(SafetyChecks::animatedCheck, SafetyLevel.arg(SafetyChecks::textureCheck, 256), SafetyLevel.arg(SafetyChecks::sizeCheck, 100), SafetyLevel.arg(SafetyChecks::cubeCountCheck, 256)),
    LOW(SafetyLevel.arg(SafetyChecks::textureCheck, 512), SafetyLevel.arg(SafetyChecks::sizeCheck, 1024), SafetyLevel.arg(SafetyChecks::cubeCountCheck, 1024)),
    NONE(new EditorPredicate[0]);

    public static final SafetyLevel[] VALUES;
    private List<EditorPredicate> checks;

    private SafetyLevel(EditorPredicate ... checks) {
        this.checks = Arrays.asList(checks);
    }

    private static <T> EditorPredicate arg(ArgEditorPredicate<T> check, T arg) {
        return (e, r) -> check.test(e, arg, r);
    }

    public static SafetyReport getLevel(Editor e) {
        for (SafetyLevel l : VALUES) {
            SafetyReport r = new SafetyReport(l);
            if (!l.checks.stream().allMatch(p -> p.test(e, r))) continue;
            return r;
        }
        return new SafetyReport(NONE);
    }

    static {
        VALUES = SafetyLevel.values();
    }

    @FunctionalInterface
    public static interface ArgEditorPredicate<A> {
        public boolean test(Editor var1, A var2, SafetyReport var3);
    }

    @FunctionalInterface
    public static interface EditorPredicate {
        public boolean test(Editor var1, SafetyReport var2);
    }

    public static class SafetyReport {
        public final SafetyLevel lvl;
        public List<FormatText> details = new ArrayList<FormatText>();

        public SafetyReport(SafetyLevel lvl) {
            this.lvl = lvl;
        }

        public String getLvl() {
            return this.lvl.name().toLowerCase();
        }
    }
}

